/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.primitives;

import org.rajawali3d.Object3D;

public class Sphere
extends Object3D {
    private final float mRadius;
    private final int mSegmentsW;
    private final int mSegmentsH;
    private final boolean mCreateTextureCoords;
    private final boolean mCreateVertexColorBuffer;
    private final boolean mMirrorTextureCoords;

    public Sphere(float radius, int segmentsW, int segmentsH) {
        this(radius, segmentsW, segmentsH, true, false, true);
    }

    public Sphere(float radius, int segmentsW, int segmentsH, boolean mirrorTextureCoords) {
        this(radius, segmentsW, segmentsH, true, false, true, mirrorTextureCoords);
    }

    public Sphere(float radius, int segmentsW, int segmentsH, boolean createTextureCoordinates, boolean createVertexColorBuffer, boolean createVBOs) {
        this(radius, segmentsW, segmentsH, createTextureCoordinates, createVertexColorBuffer, createVBOs, false);
    }

    public Sphere(float radius, int segmentsW, int segmentsH, boolean createTextureCoordinates, boolean createVertexColorBuffer, boolean createVBOs, boolean mirrorTextureCoords) {
        this.mRadius = radius;
        this.mSegmentsW = segmentsW;
        this.mSegmentsH = segmentsH;
        this.mCreateTextureCoords = createTextureCoordinates;
        this.mCreateVertexColorBuffer = createVertexColorBuffer;
        this.mMirrorTextureCoords = mirrorTextureCoords;
        this.init(createVBOs);
    }

    protected void init(boolean createVBOs) {
        int i;
        int j;
        int numVertices = (this.mSegmentsW + 1) * (this.mSegmentsH + 1);
        int numIndices = 2 * this.mSegmentsW * (this.mSegmentsH - 1) * 3;
        float[] vertices = new float[numVertices * 3];
        float[] normals = new float[numVertices * 3];
        int[] indices = new int[numIndices];
        int vertIndex = 0;
        int index = 0;
        float normLen = 1.0f / this.mRadius;
        for (j = 0; j <= this.mSegmentsH; ++j) {
            float horAngle = (float)(Math.PI * (double)j / (double)this.mSegmentsH);
            float z = this.mRadius * (float)Math.cos(horAngle);
            float ringRadius = this.mRadius * (float)Math.sin(horAngle);
            for (i = 0; i <= this.mSegmentsW; ++i) {
                float verAngle = (float)(Math.PI * 2 * (double)i / (double)this.mSegmentsW);
                float x = ringRadius * (float)Math.cos(verAngle);
                float y = ringRadius * (float)Math.sin(verAngle);
                normals[vertIndex] = x * normLen;
                vertices[vertIndex++] = x;
                normals[vertIndex] = z * normLen;
                vertices[vertIndex++] = z;
                normals[vertIndex] = y * normLen;
                vertices[vertIndex++] = y;
                if (i <= 0 || j <= 0) continue;
                int a = (this.mSegmentsW + 1) * j + i;
                int b = (this.mSegmentsW + 1) * j + i - 1;
                int c = (this.mSegmentsW + 1) * (j - 1) + i - 1;
                int d = (this.mSegmentsW + 1) * (j - 1) + i;
                if (j == this.mSegmentsH) {
                    indices[index++] = a;
                    indices[index++] = c;
                    indices[index++] = d;
                    continue;
                }
                if (j == 1) {
                    indices[index++] = a;
                    indices[index++] = b;
                    indices[index++] = c;
                    continue;
                }
                indices[index++] = a;
                indices[index++] = b;
                indices[index++] = c;
                indices[index++] = a;
                indices[index++] = c;
                indices[index++] = d;
            }
        }
        float[] textureCoords = null;
        if (this.mCreateTextureCoords) {
            int numUvs = (this.mSegmentsH + 1) * (this.mSegmentsW + 1) * 2;
            textureCoords = new float[numUvs];
            numUvs = 0;
            for (j = 0; j <= this.mSegmentsH; ++j) {
                for (i = this.mSegmentsW; i >= 0; --i) {
                    float u = (float)i / (float)this.mSegmentsW;
                    textureCoords[numUvs++] = this.mMirrorTextureCoords ? 1.0f - u : u;
                    textureCoords[numUvs++] = (float)j / (float)this.mSegmentsH;
                }
            }
        }
        float[] colors = null;
        if (this.mCreateVertexColorBuffer) {
            int numColors = numVertices * 4;
            colors = new float[numColors];
            for (j = 0; j < numColors; j += 4) {
                colors[j] = 1.0f;
                colors[j + 1] = 0.0f;
                colors[j + 2] = 0.0f;
                colors[j + 3] = 1.0f;
            }
        }
        this.setData(vertices, normals, textureCoords, colors, indices, createVBOs);
    }
}

