/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.primitives;

import org.rajawali3d.Object3D;
import org.rajawali3d.cameras.Camera;
import org.rajawali3d.cameras.Camera2D;
import org.rajawali3d.materials.Material;
import org.rajawali3d.math.Matrix4;
import org.rajawali3d.postprocessing.passes.EffectPass;

public class ScreenQuad
extends Object3D {
    protected int mSegmentsW;
    protected int mSegmentsH;
    protected int mNumTextureTiles;
    private boolean mCreateTextureCoords;
    private boolean mCreateVertexColorBuffer;
    private Camera2D mCamera;
    private Matrix4 mVPMatrix;
    private EffectPass mEffectPass;

    public ScreenQuad() {
        this(1, 1, true, false, 1, true);
    }

    public ScreenQuad(boolean createVBOs) {
        this(1, 1, true, false, 1, createVBOs);
    }

    public ScreenQuad(int segmentsW, int segmentsH) {
        this(segmentsW, segmentsH, true, false, 1, true);
    }

    public ScreenQuad(int segmentsW, int segmentsH, int numTextureTiles, boolean createVBOs) {
        this(segmentsW, segmentsH, true, false, numTextureTiles, createVBOs);
    }

    public ScreenQuad(int segmentsW, int segmentsH, boolean createVBOs) {
        this(segmentsW, segmentsH, true, false, 1, createVBOs);
    }

    public ScreenQuad(int segmentsW, int segmentsH, boolean createTextureCoordinates, boolean createVertexColorBuffer, boolean createVBOs) {
        this(segmentsW, segmentsH, createTextureCoordinates, createVertexColorBuffer, 1, createVBOs);
    }

    public ScreenQuad(int segmentsW, int segmentsH, boolean createTextureCoordinates, boolean createVertexColorBuffer, int numTextureTiles, boolean createVBOs) {
        this.mSegmentsW = segmentsW;
        this.mSegmentsH = segmentsH;
        this.mCreateTextureCoords = createTextureCoordinates;
        this.mCreateVertexColorBuffer = createVertexColorBuffer;
        this.mNumTextureTiles = numTextureTiles;
        this.init(createVBOs);
    }

    private void init(boolean createVBOs) {
        int j;
        int numVertices = (this.mSegmentsW + 1) * (this.mSegmentsH + 1);
        float[] vertices = new float[numVertices * 3];
        float[] textureCoords = null;
        if (this.mCreateTextureCoords) {
            textureCoords = new float[numVertices * 2];
        }
        float[] normals = new float[numVertices * 3];
        float[] colors = null;
        if (this.mCreateVertexColorBuffer) {
            colors = new float[numVertices * 4];
        }
        int[] indices = new int[this.mSegmentsW * this.mSegmentsH * 6];
        int vertexCount = 0;
        int texCoordCount = 0;
        this.mCamera = new Camera2D();
        this.mCamera.setProjectionMatrix(0, 0);
        this.mVPMatrix = new Matrix4();
        for (int i = 0; i <= this.mSegmentsW; ++i) {
            for (j = 0; j <= this.mSegmentsH; ++j) {
                float v1 = (float)i / (float)this.mSegmentsW - 0.5f;
                float v2 = (float)j / (float)this.mSegmentsH - 0.5f;
                vertices[vertexCount] = v1;
                vertices[vertexCount + 1] = v2;
                vertices[vertexCount + 2] = 0.0f;
                if (this.mCreateTextureCoords) {
                    float u = (float)i / (float)this.mSegmentsW;
                    textureCoords[texCoordCount++] = u * (float)this.mNumTextureTiles;
                    float v = (float)j / (float)this.mSegmentsH;
                    textureCoords[texCoordCount++] = (1.0f - v) * (float)this.mNumTextureTiles;
                }
                normals[vertexCount] = 0.0f;
                normals[vertexCount + 1] = 0.0f;
                normals[vertexCount + 2] = 1.0f;
                vertexCount += 3;
            }
        }
        int colspan = this.mSegmentsH + 1;
        int indexCount = 0;
        for (int col = 0; col < this.mSegmentsW; ++col) {
            for (int row = 0; row < this.mSegmentsH; ++row) {
                int ul = col * colspan + row;
                int ll = ul + 1;
                int ur = (col + 1) * colspan + row;
                int lr = ur + 1;
                indices[indexCount++] = ur;
                indices[indexCount++] = lr;
                indices[indexCount++] = ul;
                indices[indexCount++] = lr;
                indices[indexCount++] = ll;
                indices[indexCount++] = ul;
            }
        }
        if (this.mCreateVertexColorBuffer) {
            int numColors = numVertices * 4;
            for (j = 0; j < numColors; j += 4) {
                colors[j] = 1.0f;
                colors[j + 1] = 1.0f;
                colors[j + 2] = 1.0f;
                colors[j + 3] = 1.0f;
            }
        }
        this.setData(vertices, normals, textureCoords, colors, indices, createVBOs);
        vertices = null;
        normals = null;
        textureCoords = null;
        colors = null;
        indices = null;
        this.mEnableDepthTest = false;
        this.mEnableDepthMask = false;
    }

    @Override
    public void render(Camera camera, Matrix4 vpMatrix, Matrix4 projMatrix, Matrix4 vMatrix, Matrix4 parentMatrix, Material sceneMaterial) {
        Matrix4 pMatrix = this.mCamera.getProjectionMatrix();
        Matrix4 viewMatrix = this.mCamera.getViewMatrix();
        this.mVPMatrix.setAll(pMatrix).multiply(viewMatrix);
        super.render(this.mCamera, this.mVPMatrix, projMatrix, viewMatrix, null, sceneMaterial);
    }

    @Override
    protected void setShaderParams(Camera camera) {
        super.setShaderParams(camera);
        if (this.mEffectPass != null) {
            this.mEffectPass.setShaderParams();
        }
    }

    public void setEffectPass(EffectPass effectPass) {
        this.mEffectPass = effectPass;
    }
}

