/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.primitives;

import org.rajawali3d.Object3D;
import org.rajawali3d.math.vector.Vector3;

public class Plane
extends Object3D {
    protected float mWidth;
    protected float mHeight;
    protected int mSegmentsW;
    protected int mSegmentsH;
    protected int mNumTextureTiles;
    private boolean mCreateTextureCoords;
    private boolean mCreateVertexColorBuffer;
    private Vector3.Axis mUpAxis;

    public Plane() {
        this(1.0f, 1.0f, 1, 1, Vector3.Axis.Z, true, false, 1);
    }

    public Plane(Vector3.Axis upAxis) {
        this(1.0f, 1.0f, 1, 1, upAxis, true, false, 1);
    }

    public Plane(float width, float height, int segmentsW, int segmentsH) {
        this(width, height, segmentsW, segmentsH, Vector3.Axis.Z, true, false, 1);
    }

    public Plane(float width, float height, int segmentsW, int segmentsH, int numTextureTiles) {
        this(width, height, segmentsW, segmentsH, Vector3.Axis.Z, true, false, numTextureTiles);
    }

    public Plane(float width, float height, int segmentsW, int segmentsH, Vector3.Axis upAxis) {
        this(width, height, segmentsW, segmentsH, upAxis, true, false, 1);
    }

    public Plane(float width, float height, int segmentsW, int segmentsH, Vector3.Axis upAxis, boolean createTextureCoordinates, boolean createVertexColorBuffer) {
        this(width, height, segmentsW, segmentsH, upAxis, createTextureCoordinates, createVertexColorBuffer, 1);
    }

    public Plane(float width, float height, int segmentsW, int segmentsH, Vector3.Axis upAxis, boolean createTextureCoordinates, boolean createVertexColorBuffer, int numTextureTiles) {
        this(width, height, segmentsW, segmentsH, upAxis, createTextureCoordinates, createVertexColorBuffer, numTextureTiles, true);
    }

    public Plane(float width, float height, int segmentsW, int segmentsH, Vector3.Axis upAxis, boolean createTextureCoordinates, boolean createVertexColorBuffer, int numTextureTiles, boolean createVBOs) {
        this.mWidth = width;
        this.mHeight = height;
        this.mSegmentsW = segmentsW;
        this.mSegmentsH = segmentsH;
        this.mUpAxis = upAxis;
        this.mCreateTextureCoords = createTextureCoordinates;
        this.mCreateVertexColorBuffer = createVertexColorBuffer;
        this.mNumTextureTiles = numTextureTiles;
        this.init(createVBOs);
    }

    private void init(boolean createVBOs) {
        int j;
        int numVertices = (this.mSegmentsW + 1) * (this.mSegmentsH + 1);
        float[] vertices = new float[numVertices * 3];
        float[] textureCoords = null;
        if (this.mCreateTextureCoords) {
            textureCoords = new float[numVertices * 2];
        }
        float[] normals = new float[numVertices * 3];
        float[] colors = null;
        if (this.mCreateVertexColorBuffer) {
            colors = new float[numVertices * 4];
        }
        int[] indices = new int[this.mSegmentsW * this.mSegmentsH * 6];
        int vertexCount = 0;
        int texCoordCount = 0;
        for (int i = 0; i <= this.mSegmentsW; ++i) {
            for (j = 0; j <= this.mSegmentsH; ++j) {
                float v1 = ((float)i / (float)this.mSegmentsW - 0.5f) * this.mWidth;
                float v2 = ((float)j / (float)this.mSegmentsH - 0.5f) * this.mHeight;
                if (this.mUpAxis == Vector3.Axis.X) {
                    vertices[vertexCount] = 0.0f;
                    vertices[vertexCount + 1] = v1;
                    vertices[vertexCount + 2] = v2;
                } else if (this.mUpAxis == Vector3.Axis.Y) {
                    vertices[vertexCount] = v1;
                    vertices[vertexCount + 1] = 0.0f;
                    vertices[vertexCount + 2] = v2;
                } else if (this.mUpAxis == Vector3.Axis.Z) {
                    vertices[vertexCount] = v1;
                    vertices[vertexCount + 1] = v2;
                    vertices[vertexCount + 2] = 0.0f;
                }
                if (this.mCreateTextureCoords) {
                    float u = (float)i / (float)this.mSegmentsW;
                    textureCoords[texCoordCount++] = u * (float)this.mNumTextureTiles;
                    float v = (float)j / (float)this.mSegmentsH;
                    textureCoords[texCoordCount++] = (1.0f - v) * (float)this.mNumTextureTiles;
                }
                normals[vertexCount] = this.mUpAxis == Vector3.Axis.X ? 1.0f : 0.0f;
                normals[vertexCount + 1] = this.mUpAxis == Vector3.Axis.Y ? 1.0f : 0.0f;
                normals[vertexCount + 2] = this.mUpAxis == Vector3.Axis.Z ? 1.0f : 0.0f;
                vertexCount += 3;
            }
        }
        int colspan = this.mSegmentsH + 1;
        int indexCount = 0;
        for (int col = 0; col < this.mSegmentsW; ++col) {
            for (int row = 0; row < this.mSegmentsH; ++row) {
                int ul = col * colspan + row;
                int ll = ul + 1;
                int ur = (col + 1) * colspan + row;
                int lr = ur + 1;
                if (this.mUpAxis == Vector3.Axis.X || this.mUpAxis == Vector3.Axis.Z) {
                    indices[indexCount++] = ur;
                    indices[indexCount++] = lr;
                    indices[indexCount++] = ul;
                    indices[indexCount++] = lr;
                    indices[indexCount++] = ll;
                    indices[indexCount++] = ul;
                    continue;
                }
                indices[indexCount++] = ur;
                indices[indexCount++] = ul;
                indices[indexCount++] = lr;
                indices[indexCount++] = lr;
                indices[indexCount++] = ul;
                indices[indexCount++] = ll;
            }
        }
        if (this.mCreateVertexColorBuffer) {
            int numColors = numVertices * 4;
            for (j = 0; j < numColors; j += 4) {
                colors[j] = 1.0f;
                colors[j + 1] = 1.0f;
                colors[j + 2] = 1.0f;
                colors[j + 3] = 1.0f;
            }
        }
        this.setData(vertices, normals, textureCoords, colors, indices, createVBOs);
        vertices = null;
        normals = null;
        textureCoords = null;
        colors = null;
        indices = null;
    }
}

