/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.primitives;

import org.rajawali3d.Object3D;
import org.rajawali3d.math.vector.Vector3;

public class NPrism
extends Object3D {
    protected int mSideCount;
    protected double mRadiusBase;
    protected double mRadiusTop;
    protected double mMinorBase;
    protected double mMinorTop;
    protected double mHeight;
    protected double mEccentricity;
    private static final Vector3 UP = new Vector3(0.0, 1.0, 0.0);
    private static final Vector3 DOWN = new Vector3(0.0, -1.0, 0.0);
    private int mVertexIndex;
    private int mTextureIndex;
    private int mNormalIndex;
    private int mColorIndex;

    public NPrism(int sides, double radius, double height) {
        this(sides, 0.0, radius, height);
    }

    public NPrism(int sides, double radiusTop, double radiusBase, double height) {
        this(sides, radiusTop, radiusBase, 0.0, height, true);
    }

    public NPrism(int sides, double radiusTop, double radiusBase, double eccentricity, double height) {
        this(sides, radiusTop, radiusBase, eccentricity, height, true);
    }

    public NPrism(int sides, double radiusTop, double radiusBase, double eccentricity, double height, boolean createVBOs) {
        if (sides < 3) {
            throw new IllegalArgumentException("Prisms must have at least 3 sides!");
        }
        if (eccentricity < 0.0 || eccentricity >= 1.0) {
            throw new IllegalArgumentException("Eccentricity must be in the range [0,1)");
        }
        this.mSideCount = sides;
        this.mEccentricity = eccentricity;
        this.mRadiusTop = radiusTop;
        this.mMinorTop = this.calculateMinorAxis(this.mRadiusTop);
        this.mRadiusBase = radiusBase;
        this.mMinorBase = this.calculateMinorAxis(this.mRadiusBase);
        this.mHeight = height;
        this.init(createVBOs);
    }

    protected double calculateMinorAxis(double major) {
        return Math.sqrt(Math.pow(major, 2.0) * (1.0 - Math.pow(this.mEccentricity, 2.0)));
    }

    private void setIndices(int triangle) {
        this.mVertexIndex = 9 * triangle;
        this.mTextureIndex = 6 * triangle;
        this.mNormalIndex = 9 * triangle;
        this.mColorIndex = 12 * triangle;
    }

    protected void init(boolean createVBOs) {
        int vertex_count = 6 * this.mSideCount + 6 * this.mSideCount;
        int tri_count = 2 * this.mSideCount + 2 * this.mSideCount;
        int triangle = 0;
        float[] vertices = new float[3 * vertex_count];
        float[] normals = new float[3 * vertex_count];
        float[] texture = new float[2 * vertex_count];
        float[] colors = new float[4 * vertex_count];
        int[] indices = new int[3 * tri_count];
        double angle_delta = Math.PI * 2 / (double)this.mSideCount;
        int indexIndex = 0;
        double angle0 = this.mSideCount % 2 == 0 ? angle_delta / 2.0 : 0.0;
        Vector3 vertex0 = new Vector3();
        Vector3 vertex1 = new Vector3();
        Vector3 vertex2 = new Vector3();
        Vector3 scratch0 = new Vector3();
        Vector3 scratch1 = new Vector3();
        Vector3 temp_normal = new Vector3();
        for (int side = 0; side < this.mSideCount; ++side) {
            this.setIndices(triangle);
            vertex0.x = this.mRadiusTop * Math.cos(angle0 + (double)side * angle_delta);
            vertex0.y = this.mHeight / 2.0;
            vertex0.z = this.mMinorTop * Math.sin(angle0 + (double)side * angle_delta);
            vertex1.x = this.mRadiusTop * Math.cos(angle0 + (double)(side + 1) * angle_delta);
            vertex1.y = vertex0.y;
            vertex1.z = this.mMinorTop * Math.sin(angle0 + (double)(side + 1) * angle_delta);
            vertex2.x = this.mRadiusBase * Math.cos(angle0 + (double)side * angle_delta);
            vertex2.y = -vertex0.y;
            vertex2.z = this.mMinorBase * Math.sin(angle0 + (double)side * angle_delta);
            scratch0.subtractAndSet(vertex0, vertex1);
            scratch1.subtractAndSet(vertex0, vertex2);
            temp_normal.crossAndSet(scratch1, scratch0);
            temp_normal.normalize();
            vertices[this.mVertexIndex] = (float)vertex0.x;
            vertices[this.mVertexIndex + 1] = (float)vertex0.y;
            vertices[this.mVertexIndex + 2] = (float)vertex0.z;
            normals[this.mNormalIndex] = (float)temp_normal.x;
            normals[this.mNormalIndex + 1] = (float)temp_normal.y;
            normals[this.mNormalIndex + 2] = (float)temp_normal.z;
            texture[this.mTextureIndex] = (float)Math.cos(angle0 + (double)side * angle_delta);
            texture[this.mTextureIndex + 1] = 1.0f;
            vertices[this.mVertexIndex + 3] = (float)vertex1.x;
            vertices[this.mVertexIndex + 4] = (float)vertex1.y;
            vertices[this.mVertexIndex + 5] = (float)vertex1.z;
            normals[this.mNormalIndex + 3] = (float)temp_normal.x;
            normals[this.mNormalIndex + 4] = (float)temp_normal.y;
            normals[this.mNormalIndex + 5] = (float)temp_normal.z;
            texture[this.mTextureIndex + 2] = (float)Math.cos(angle0 + (double)(side + 1) * angle_delta);
            texture[this.mTextureIndex + 3] = 1.0f;
            vertices[this.mVertexIndex + 6] = (float)vertex2.x;
            vertices[this.mVertexIndex + 7] = (float)vertex2.y;
            vertices[this.mVertexIndex + 8] = (float)vertex2.z;
            normals[this.mNormalIndex + 6] = (float)temp_normal.x;
            normals[this.mNormalIndex + 7] = (float)temp_normal.y;
            normals[this.mNormalIndex + 8] = (float)temp_normal.z;
            texture[this.mTextureIndex + 4] = (float)Math.cos(angle0 + (double)side * angle_delta);
            texture[this.mTextureIndex + 5] = 0.0f;
            indices[indexIndex] = indexIndex;
            indices[indexIndex + 1] = indexIndex + 1;
            indices[indexIndex + 2] = indexIndex + 2;
            indexIndex += 3;
            this.setIndices(++triangle);
            vertex0.x = vertex2.x;
            vertex0.y = vertex2.y;
            vertex0.z = vertex2.z;
            vertex2.x = this.mRadiusBase * Math.cos(angle0 + (double)(side + 1) * angle_delta);
            vertex2.y = -this.mHeight / 2.0;
            vertex2.z = this.mMinorBase * Math.sin(angle0 + (double)(side + 1) * angle_delta);
            scratch0.subtractAndSet(vertex2, vertex0);
            scratch1.subtractAndSet(vertex2, vertex1);
            temp_normal.crossAndSet(scratch1, scratch0);
            temp_normal.normalize();
            vertices[this.mVertexIndex] = (float)vertex0.x;
            vertices[this.mVertexIndex + 1] = (float)vertex0.y;
            vertices[this.mVertexIndex + 2] = (float)vertex0.z;
            normals[this.mNormalIndex] = (float)temp_normal.x;
            normals[this.mNormalIndex + 1] = (float)temp_normal.y;
            normals[this.mNormalIndex + 2] = (float)temp_normal.z;
            texture[this.mTextureIndex] = (float)Math.cos(angle0 + (double)side * angle_delta);
            texture[this.mTextureIndex + 1] = 0.0f;
            vertices[this.mVertexIndex + 3] = (float)vertex1.x;
            vertices[this.mVertexIndex + 4] = (float)vertex1.y;
            vertices[this.mVertexIndex + 5] = (float)vertex1.z;
            normals[this.mNormalIndex + 3] = (float)temp_normal.x;
            normals[this.mNormalIndex + 4] = (float)temp_normal.y;
            normals[this.mNormalIndex + 5] = (float)temp_normal.z;
            texture[this.mTextureIndex + 2] = (float)Math.cos(angle0 + (double)(side + 1) * angle_delta);
            texture[this.mTextureIndex + 3] = 1.0f;
            vertices[this.mVertexIndex + 6] = (float)vertex2.x;
            vertices[this.mVertexIndex + 7] = (float)vertex2.y;
            vertices[this.mVertexIndex + 8] = (float)vertex2.z;
            normals[this.mNormalIndex + 6] = (float)temp_normal.x;
            normals[this.mNormalIndex + 7] = (float)temp_normal.y;
            normals[this.mNormalIndex + 8] = (float)temp_normal.z;
            texture[this.mTextureIndex + 4] = (float)Math.cos(angle0 + (double)(side + 1) * angle_delta);
            texture[this.mTextureIndex + 5] = 0.0f;
            indices[indexIndex] = indexIndex;
            indices[indexIndex + 1] = indexIndex + 1;
            indices[indexIndex + 2] = indexIndex + 2;
            indexIndex += 3;
            this.setIndices(++triangle);
            vertex0.x = this.mRadiusTop * Math.cos(angle0 + (double)side * angle_delta);
            vertex0.y = this.mHeight / 2.0;
            vertex0.z = this.mMinorTop * Math.sin(angle0 + (double)side * angle_delta);
            vertex1.x = 0.0;
            vertex1.y = vertex0.y;
            vertex1.z = 0.0;
            vertex2.x = this.mRadiusTop * Math.cos(angle0 + (double)(side + 1) * angle_delta);
            vertex2.y = vertex0.y;
            vertex2.z = this.mMinorTop * Math.sin(angle0 + (double)(side + 1) * angle_delta);
            temp_normal.x = 0.0;
            temp_normal.y = 1.0;
            temp_normal.z = 0.0;
            vertices[this.mVertexIndex] = (float)vertex0.x;
            vertices[this.mVertexIndex + 1] = (float)vertex0.y;
            vertices[this.mVertexIndex + 2] = (float)vertex0.z;
            normals[this.mNormalIndex] = (float)temp_normal.x;
            normals[this.mNormalIndex + 1] = (float)temp_normal.y;
            normals[this.mNormalIndex + 2] = (float)temp_normal.z;
            texture[this.mTextureIndex] = (float)Math.cos(angle0 + (double)side * angle_delta);
            texture[this.mTextureIndex + 1] = 1.0f;
            vertices[this.mVertexIndex + 3] = (float)vertex1.x;
            vertices[this.mVertexIndex + 4] = (float)vertex1.y;
            vertices[this.mVertexIndex + 5] = (float)vertex1.z;
            normals[this.mNormalIndex + 3] = (float)temp_normal.x;
            normals[this.mNormalIndex + 4] = (float)temp_normal.y;
            normals[this.mNormalIndex + 5] = (float)temp_normal.z;
            texture[this.mTextureIndex + 2] = (float)Math.cos(angle0 + (double)(side + 1) * angle_delta);
            texture[this.mTextureIndex + 3] = 1.0f;
            vertices[this.mVertexIndex + 6] = (float)vertex2.x;
            vertices[this.mVertexIndex + 7] = (float)vertex2.y;
            vertices[this.mVertexIndex + 8] = (float)vertex2.z;
            normals[this.mNormalIndex + 6] = (float)temp_normal.x;
            normals[this.mNormalIndex + 7] = (float)temp_normal.y;
            normals[this.mNormalIndex + 8] = (float)temp_normal.z;
            texture[this.mTextureIndex + 4] = (float)Math.cos(angle0 + (double)side * angle_delta);
            texture[this.mTextureIndex + 5] = 1.0f;
            indices[indexIndex] = indexIndex;
            indices[indexIndex + 1] = indexIndex + 1;
            indices[indexIndex + 2] = indexIndex + 2;
            indexIndex += 3;
            this.setIndices(++triangle);
            vertex0.x = this.mRadiusBase * Math.cos(angle0 + (double)side * angle_delta);
            vertex0.y = -this.mHeight / 2.0;
            vertex0.z = this.mMinorBase * Math.sin(angle0 + (double)side * angle_delta);
            vertex1.x = 0.0;
            vertex1.y = vertex0.y;
            vertex1.z = 0.0;
            vertex2.x = this.mRadiusBase * Math.cos(angle0 + (double)(side + 1) * angle_delta);
            vertex2.y = vertex0.y;
            vertex2.z = this.mMinorBase * Math.sin(angle0 + (double)(side + 1) * angle_delta);
            temp_normal.x = 0.0;
            temp_normal.y = -1.0;
            temp_normal.z = 0.0;
            vertices[this.mVertexIndex] = (float)vertex0.x;
            vertices[this.mVertexIndex + 1] = (float)vertex0.y;
            vertices[this.mVertexIndex + 2] = (float)vertex0.z;
            normals[this.mNormalIndex] = (float)temp_normal.x;
            normals[this.mNormalIndex + 1] = (float)temp_normal.y;
            normals[this.mNormalIndex + 2] = (float)temp_normal.z;
            texture[this.mTextureIndex] = (float)Math.cos(angle0 + (double)side * angle_delta);
            texture[this.mTextureIndex + 1] = 1.0f;
            vertices[this.mVertexIndex + 3] = (float)vertex1.x;
            vertices[this.mVertexIndex + 4] = (float)vertex1.y;
            vertices[this.mVertexIndex + 5] = (float)vertex1.z;
            normals[this.mNormalIndex + 3] = (float)temp_normal.x;
            normals[this.mNormalIndex + 4] = (float)temp_normal.y;
            normals[this.mNormalIndex + 5] = (float)temp_normal.z;
            texture[this.mTextureIndex + 2] = (float)Math.cos(angle0 + (double)(side + 1) * angle_delta);
            texture[this.mTextureIndex + 3] = 1.0f;
            vertices[this.mVertexIndex + 6] = (float)vertex2.x;
            vertices[this.mVertexIndex + 7] = (float)vertex2.y;
            vertices[this.mVertexIndex + 8] = (float)vertex2.z;
            normals[this.mNormalIndex + 6] = (float)temp_normal.x;
            normals[this.mNormalIndex + 7] = (float)temp_normal.y;
            normals[this.mNormalIndex + 8] = (float)temp_normal.z;
            texture[this.mTextureIndex + 4] = (float)Math.cos(angle0 + (double)side * angle_delta);
            texture[this.mTextureIndex + 5] = 0.0f;
            indices[indexIndex] = indexIndex;
            indices[indexIndex + 1] = indexIndex + 1;
            indices[indexIndex + 2] = indexIndex + 2;
            indexIndex += 3;
            ++triangle;
        }
        int j = 4 * vertex_count;
        for (int i = 0; i < j; ++i) {
            colors[i] = 1.0f;
        }
        this.setData(vertices, normals, texture, colors, indices, createVBOs);
    }
}

