/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.primitives;

import android.graphics.Color;
import android.opengl.GLES20;
import java.util.Stack;
import org.rajawali3d.Object3D;
import org.rajawali3d.math.vector.Vector3;

public class Line3D
extends Object3D {
    protected Stack<Vector3> mPoints;
    protected float mLineThickness;
    protected int[] mColors;

    public Line3D() {
    }

    public Line3D(Stack<Vector3> points, float thickness) {
        this(points, thickness, null);
    }

    public Line3D(Stack<Vector3> points, float thickness, int color) {
        this(points, thickness, null);
        this.setColor(color);
    }

    public Line3D(Stack<Vector3> points, float thickness, int[] colors) {
        this(points, thickness, colors, true);
    }

    public Line3D(Stack<Vector3> points, float thickness, int[] colors, boolean createVBOs) {
        this.mPoints = points;
        this.mLineThickness = thickness;
        this.mColors = colors;
        if (colors != null && colors.length != points.size()) {
            throw new RuntimeException("The number of line points and colors is not the same.");
        }
        this.init(createVBOs);
    }

    public Vector3 getPoint(int point) {
        return (Vector3)this.mPoints.get(point);
    }

    protected void init(boolean createVBOs) {
        this.setDoubleSided(true);
        this.setDrawingMode(3);
        int numVertices = this.mPoints.size();
        float[] vertices = new float[numVertices * 3];
        int[] indices = new int[numVertices];
        float[] colors = null;
        if (this.mColors != null) {
            colors = new float[this.mColors.length * 4];
        }
        for (int i = 0; i < numVertices; ++i) {
            Vector3 point = (Vector3)this.mPoints.get(i);
            int index = i * 3;
            vertices[index] = (float)point.x;
            vertices[index + 1] = (float)point.y;
            vertices[index + 2] = (float)point.z;
            indices[i] = (short)i;
            if (this.mColors == null) continue;
            int color = this.mColors[i];
            int colorIndex = i * 4;
            colors[colorIndex] = (float)Color.red((int)color) / 255.0f;
            colors[colorIndex + 1] = (float)Color.green((int)color) / 255.0f;
            colors[colorIndex + 2] = (float)Color.blue((int)color) / 255.0f;
            colors[colorIndex + 3] = (float)Color.alpha((int)color) / 255.0f;
        }
        this.setData(vertices, null, null, colors, indices, createVBOs);
        vertices = null;
        colors = null;
        indices = null;
    }

    @Override
    public void preRender() {
        super.preRender();
        GLES20.glLineWidth((float)this.mLineThickness);
    }

    public void setLineThickness(float lineThickness) {
        this.mLineThickness = lineThickness;
    }

    public float getLineThickness() {
        return this.mLineThickness;
    }
}

