/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.primitives;

import org.rajawali3d.Object3D;

public class Cylinder
extends Object3D {
    private final float PI = (float)Math.PI;
    private float mLength;
    private float mRadius;
    private int mSegmentsC;
    private int mSegmentsL;
    private boolean mCreateTextureCoords;
    private boolean mCreateVertexColorBuffer;

    public Cylinder(float length, float radius, int segmentsL, int segmentsC) {
        this(length, radius, segmentsL, segmentsC, true, false, true);
    }

    public Cylinder(float length, float radius, int segmentsL, int segmentsC, boolean createTextureCoordinates, boolean createVertexColorBuffer, boolean createVBOs) {
        this.mLength = length;
        this.mRadius = radius;
        this.mSegmentsL = segmentsL;
        this.mSegmentsC = segmentsC;
        this.mCreateTextureCoords = createTextureCoordinates;
        this.mCreateVertexColorBuffer = createVertexColorBuffer;
        this.init(createVBOs);
    }

    protected void init(boolean createVBOs) {
        int i;
        int j;
        int numVertices = (this.mSegmentsC + 1) * (this.mSegmentsL + 1);
        int numIndices = 2 * this.mSegmentsC * this.mSegmentsL * 3;
        float[] vertices = new float[numVertices * 3];
        float[] normals = new float[numVertices * 3];
        int[] indices = new int[numIndices];
        int vertIndex = 0;
        int index = 0;
        float normLen = 1.0f / this.mRadius;
        for (j = 0; j <= this.mSegmentsL; ++j) {
            float z = this.mLength * ((float)j / (float)this.mSegmentsL) - this.mLength / 2.0f;
            for (i = 0; i <= this.mSegmentsC; ++i) {
                float verAngle = (float)Math.PI * 2 * (float)i / (float)this.mSegmentsC;
                float x = this.mRadius * (float)Math.cos(verAngle);
                float y = this.mRadius * (float)Math.sin(verAngle);
                normals[vertIndex] = x * normLen;
                vertices[vertIndex++] = x;
                normals[vertIndex] = y * normLen;
                vertices[vertIndex++] = y;
                normals[vertIndex] = 0.0f;
                vertices[vertIndex++] = z;
                if (i <= 0 || j <= 0) continue;
                int a = (this.mSegmentsC + 1) * j + i;
                int b = (this.mSegmentsC + 1) * j + i - 1;
                int c = (this.mSegmentsC + 1) * (j - 1) + i - 1;
                int d = (this.mSegmentsC + 1) * (j - 1) + i;
                indices[index++] = a;
                indices[index++] = b;
                indices[index++] = c;
                indices[index++] = a;
                indices[index++] = c;
                indices[index++] = d;
            }
        }
        float[] textureCoords = null;
        if (this.mCreateTextureCoords) {
            int numUvs = (this.mSegmentsL + 1) * (this.mSegmentsC + 1) * 2;
            textureCoords = new float[numUvs];
            numUvs = 0;
            for (j = 0; j <= this.mSegmentsL; ++j) {
                for (i = this.mSegmentsC; i >= 0; --i) {
                    textureCoords[numUvs++] = (float)i / (float)this.mSegmentsC;
                    textureCoords[numUvs++] = (float)j / (float)this.mSegmentsL;
                }
            }
        }
        float[] colors = null;
        if (this.mCreateVertexColorBuffer) {
            int numColors = numVertices * 4;
            colors = new float[numColors];
            for (j = 0; j < numColors; j += 4) {
                colors[j] = 1.0f;
                colors[j + 1] = 0.0f;
                colors[j + 2] = 0.0f;
                colors[j + 3] = 1.0f;
            }
        }
        this.setData(vertices, normals, textureCoords, colors, indices, createVBOs);
        vertices = null;
        normals = null;
        textureCoords = null;
        indices = null;
    }
}

