/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.postprocessing.passes;

import org.rajawali3d.R;
import org.rajawali3d.postprocessing.passes.EffectPass;

public class VignettePass
extends EffectPass {
    protected float[] mResolution;
    protected float mRadius;
    protected float mSoftness;

    public VignettePass(float opacity, float radius, float softness, int screenWidth, int screenHeight) {
        this.setSize(screenWidth, screenHeight);
        this.setOpacity(opacity);
        this.setRadius(radius);
        this.setSoftness(softness);
        this.createMaterial(R.raw.minimal_vertex_shader, R.raw.vignette_fragment_shader);
    }

    @Override
    public void setShaderParams() {
        super.setShaderParams();
        this.mFragmentShader.setUniform1f("uRadius", this.mRadius);
        this.mFragmentShader.setUniform1f("uSoftness", this.mSoftness);
        this.mFragmentShader.setUniform2fv("uResolution", this.mResolution);
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.mResolution = new float[]{width, height};
    }

    public void setRadius(float radius) {
        this.mRadius = radius > 1.0f ? 1.0f : (radius < 0.0f ? 0.0f : radius);
    }

    public void setSoftness(float softness) {
        this.mSoftness = softness > 1.0f ? 1.0f : (softness < 0.0f ? 0.0f : softness);
    }
}

