/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.postprocessing.passes;

import org.rajawali3d.cameras.Camera;
import org.rajawali3d.lights.DirectionalLight;
import org.rajawali3d.postprocessing.materials.ShadowMapMaterial;
import org.rajawali3d.postprocessing.passes.RenderPass;
import org.rajawali3d.primitives.ScreenQuad;
import org.rajawali3d.renderer.RenderTarget;
import org.rajawali3d.renderer.Renderer;
import org.rajawali3d.scene.Scene;

public class ShadowPass
extends RenderPass {
    private RenderTarget mShadowRenderTarget;
    private int mShadowMapSize;
    private ShadowMapMaterial mShadowMapMaterial;
    private ShadowPassType mShadowPassType;

    public ShadowPass(ShadowPassType shadowPassType, Scene scene, Camera camera, DirectionalLight light, RenderTarget renderTarget) {
        super(scene, camera, 0);
        this.mShadowPassType = shadowPassType;
        this.mShadowRenderTarget = renderTarget;
        this.mShadowMapSize = renderTarget.getWidth();
        if (shadowPassType == ShadowPassType.CREATE_SHADOW_MAP) {
            this.mShadowMapMaterial = new ShadowMapMaterial();
            this.mShadowMapMaterial.setLight(light);
            this.mShadowMapMaterial.setCamera(camera);
            this.mShadowMapMaterial.setScene(scene);
            this.setMaterial(this.mShadowMapMaterial);
        }
    }

    @Override
    public void render(Scene scene, Renderer renderer, ScreenQuad screenQuad, RenderTarget writeBuffer, RenderTarget readBuffer, long ellapsedTime, double deltaTime) {
        if (this.mShadowPassType == ShadowPassType.APPLY_SHADOW_MAP) {
            this.mShadowMapMaterial.setShadowMapTexture(this.mShadowRenderTarget.getTexture());
            super.render(scene, renderer, screenQuad, writeBuffer, readBuffer, ellapsedTime, deltaTime);
        } else {
            renderer.setOverrideViewportDimensions(this.mShadowMapSize, this.mShadowMapSize);
            super.render(scene, renderer, screenQuad, this.mShadowRenderTarget, readBuffer, ellapsedTime, deltaTime);
            renderer.clearOverrideViewportDimensions();
        }
    }

    public ShadowMapMaterial getShadowMapMaterial() {
        return this.mShadowMapMaterial;
    }

    public void setShadowMapMaterial(ShadowMapMaterial shadowMapMaterial) {
        this.mShadowMapMaterial = shadowMapMaterial;
    }

    public static enum ShadowPassType {
        CREATE_SHADOW_MAP,
        APPLY_SHADOW_MAP;

    }
}

