/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.postprocessing.passes;

import org.rajawali3d.R;
import org.rajawali3d.postprocessing.passes.EffectPass;

public class ScanlinePass
extends EffectPass {
    protected float[] mResolution;
    protected float mRadius;

    public ScanlinePass(float opacity, float radius, int screenWidth, int screenHeight) {
        this.setSize(screenWidth, screenHeight);
        this.setOpacity(opacity);
        this.setRadius(radius);
        this.createMaterial(R.raw.minimal_vertex_shader, R.raw.scanline_fragment_shader);
    }

    @Override
    public void setShaderParams() {
        super.setShaderParams();
        this.mFragmentShader.setUniform1f("uRadius", this.mRadius);
        this.mFragmentShader.setUniform2fv("uResolution", this.mResolution);
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.mResolution = new float[]{width, height};
    }

    public void setRadius(float radius) {
        this.mRadius = Math.abs(radius);
    }
}

