/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.postprocessing.passes;

import android.graphics.Color;
import android.opengl.GLES20;
import org.rajawali3d.cameras.Camera;
import org.rajawali3d.postprocessing.APass;
import org.rajawali3d.postprocessing.IPass;
import org.rajawali3d.primitives.ScreenQuad;
import org.rajawali3d.renderer.RenderTarget;
import org.rajawali3d.renderer.Renderer;
import org.rajawali3d.scene.Scene;

public class RenderPass
extends APass {
    protected Scene mScene;
    protected Camera mCamera;
    protected Camera mOldCamera;
    protected int mClearColor;
    protected int mOldClearColor;

    public RenderPass(Scene scene, Camera camera, int clearColor) {
        this.mPassType = IPass.PassType.RENDER;
        this.mScene = scene;
        this.mCamera = camera;
        this.mClearColor = clearColor;
        this.mOldClearColor = 0;
        this.mEnabled = true;
        this.mClear = true;
        this.mNeedsSwap = true;
    }

    @Override
    public void render(Scene scene, Renderer renderer, ScreenQuad screenQuad, RenderTarget writeBuffer, RenderTarget readBuffer, long ellapsedTime, double deltaTime) {
        if (this.mClearColor != 0) {
            this.mOldClearColor = renderer.getCurrentScene().getBackgroundColor();
            GLES20.glClearColor((float)((float)Color.red((int)this.mClearColor) / 255.0f), (float)((float)Color.green((int)this.mClearColor) / 255.0f), (float)((float)Color.blue((int)this.mClearColor) / 255.0f), (float)((float)Color.alpha((int)this.mClearColor) / 255.0f));
        }
        this.mOldCamera = this.mScene.getCamera();
        this.mScene.switchCamera(this.mCamera);
        this.mScene.render(ellapsedTime, deltaTime, this.mRenderToScreen ? null : writeBuffer, this.mMaterial);
        this.mScene.switchCamera(this.mOldCamera);
        if (this.mClearColor != 0) {
            GLES20.glClearColor((float)((float)Color.red((int)this.mOldClearColor) / 255.0f), (float)((float)Color.green((int)this.mOldClearColor) / 255.0f), (float)((float)Color.blue((int)this.mOldClearColor) / 255.0f), (float)((float)Color.alpha((int)this.mOldClearColor) / 255.0f));
        }
    }
}

