/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.postprocessing.passes;

import android.opengl.GLES20;
import org.rajawali3d.postprocessing.APass;
import org.rajawali3d.postprocessing.IPass;
import org.rajawali3d.primitives.ScreenQuad;
import org.rajawali3d.renderer.RenderTarget;
import org.rajawali3d.renderer.Renderer;
import org.rajawali3d.scene.Scene;

public class MaskPass
extends APass {
    protected Scene mScene;
    protected boolean mInverse;

    public MaskPass(Scene scene) {
        this.mPassType = IPass.PassType.MASK;
        this.mScene = scene;
        this.mEnabled = true;
        this.mClear = true;
        this.mNeedsSwap = false;
        this.mInverse = false;
    }

    public boolean isInverse() {
        return this.mInverse;
    }

    public void setInverse(boolean inverse) {
        this.mInverse = inverse;
    }

    @Override
    public void render(Scene scene, Renderer render, ScreenQuad screenQuad, RenderTarget writeBuffer, RenderTarget readBuffer, long ellapsedTime, double deltaTime) {
        int clearValue;
        int writeValue;
        GLES20.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        GLES20.glDepthMask((boolean)false);
        if (this.mInverse) {
            writeValue = 0;
            clearValue = 1;
        } else {
            writeValue = 1;
            clearValue = 0;
        }
        GLES20.glEnable((int)2960);
        GLES20.glStencilOp((int)7681, (int)7681, (int)7681);
        GLES20.glStencilFunc((int)519, (int)writeValue, (int)-1);
        GLES20.glClearStencil((int)clearValue);
        this.mScene.render(ellapsedTime, deltaTime, readBuffer);
        this.mScene.render(ellapsedTime, deltaTime, writeBuffer);
        GLES20.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GLES20.glDepthMask((boolean)true);
        GLES20.glStencilFunc((int)514, (int)1, (int)-1);
        GLES20.glStencilOp((int)7680, (int)7680, (int)7680);
    }
}

