/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.postprocessing.passes;

import android.opengl.GLES20;
import org.rajawali3d.R;
import org.rajawali3d.materials.shaders.FragmentShader;
import org.rajawali3d.materials.shaders.VertexShader;
import org.rajawali3d.postprocessing.passes.EffectPass;
import org.rajawali3d.primitives.ScreenQuad;
import org.rajawali3d.renderer.RenderTarget;
import org.rajawali3d.renderer.Renderer;
import org.rajawali3d.scene.Scene;

public class FXAAPass
extends EffectPass {
    private static final String TAG = "FXAAPass";

    public FXAAPass() {
        this.createMaterial(new FXAAVertexShader(), new FXAAFragmentShader());
    }

    @Override
    public void render(Scene scene, Renderer renderer, ScreenQuad screenQuad, RenderTarget writeTarget, RenderTarget readTarget, long ellapsedTime, double deltaTime) {
        super.render(scene, renderer, screenQuad, writeTarget, readTarget, ellapsedTime, deltaTime);
    }

    protected class FXAAFragmentShader
    extends FragmentShader {
        private int rtWHandle;
        private int rtHHandle;

        public FXAAFragmentShader() {
            super(R.raw.fxaa_fragment_shader);
        }

        @Override
        public void setLocations(int programHandle) {
            super.setLocations(programHandle);
            this.rtWHandle = this.getUniformLocation(programHandle, "rt_w");
            this.rtHHandle = this.getUniformLocation(programHandle, "rt_h");
        }

        @Override
        public void applyParams() {
            super.applyParams();
            GLES20.glUniform1f((int)this.rtWHandle, (float)FXAAPass.this.mReadTarget.getWidth());
            GLES20.glUniform1f((int)this.rtHHandle, (float)FXAAPass.this.mReadTarget.getHeight());
        }
    }

    protected class FXAAVertexShader
    extends VertexShader {
        private int rtWHandle;
        private int rtHHandle;

        public FXAAVertexShader() {
            super(R.raw.fxaa_vertex_shader);
        }

        @Override
        public void setLocations(int programHandle) {
            super.setLocations(programHandle);
            this.rtWHandle = this.getUniformLocation(programHandle, "rt_w");
            this.rtHHandle = this.getUniformLocation(programHandle, "rt_h");
        }

        @Override
        public void applyParams() {
            super.applyParams();
            GLES20.glUniform1f((int)this.rtWHandle, (float)FXAAPass.this.mReadTarget.getWidth());
            GLES20.glUniform1f((int)this.rtHHandle, (float)FXAAPass.this.mReadTarget.getHeight());
        }
    }
}

