/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.postprocessing.passes;

import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.RawRes;
import org.rajawali3d.materials.Material;
import org.rajawali3d.materials.shaders.FragmentShader;
import org.rajawali3d.materials.shaders.VertexShader;
import org.rajawali3d.postprocessing.APass;
import org.rajawali3d.postprocessing.IPass;
import org.rajawali3d.primitives.ScreenQuad;
import org.rajawali3d.renderer.RenderTarget;
import org.rajawali3d.renderer.Renderer;
import org.rajawali3d.scene.Scene;

public class EffectPass
extends APass {
    protected final String PARAM_OPACITY = "uOpacity";
    protected final String PARAM_TEXTURE = "uTexture";
    protected final String PARAM_DEPTH_TEXTURE = "uDepthTexture";
    protected final String PARAM_BLEND_TEXTURE = "uBlendTexture";
    protected VertexShader mVertexShader;
    protected FragmentShader mFragmentShader;
    protected RenderTarget mReadTarget;
    protected RenderTarget mWriteTarget;
    @FloatRange(from=0.0, to=1.0)
    protected float mOpacity = 1.0f;

    public EffectPass() {
        this.mPassType = IPass.PassType.EFFECT;
        this.mNeedsSwap = true;
        this.mClear = false;
        this.mEnabled = true;
        this.mRenderToScreen = false;
    }

    public EffectPass(@NonNull Material material) {
        this();
        this.setMaterial(material);
    }

    protected void createMaterial(@NonNull VertexShader vertexShader, @NonNull FragmentShader fragmentShader) {
        this.mVertexShader = vertexShader;
        this.mFragmentShader = fragmentShader;
        this.mVertexShader.setNeedsBuild(false);
        this.mFragmentShader.setNeedsBuild(false);
        this.setMaterial(new Material(this.mVertexShader, this.mFragmentShader));
    }

    protected void createMaterial(@RawRes int vertexShaderResourceId, @RawRes int fragmentShaderResourceId) {
        this.createMaterial(new VertexShader(vertexShaderResourceId), new FragmentShader(fragmentShaderResourceId));
    }

    public void setShaderParams() {
        this.mFragmentShader.setUniform1f("uOpacity", this.mOpacity);
        this.mMaterial.bindTextureByName("uTexture", 0, this.mReadTarget.getTexture());
    }

    @Override
    public void render(@NonNull Scene scene, @NonNull Renderer renderer, @NonNull ScreenQuad screenQuad, @NonNull RenderTarget writeTarget, @NonNull RenderTarget readTarget, @IntRange(from=0L) long ellapsedTime, @FloatRange(from=0.0) double deltaTime) {
        this.mReadTarget = readTarget;
        this.mWriteTarget = writeTarget;
        screenQuad.setMaterial(this.mMaterial);
        screenQuad.setEffectPass(this);
        if (this.mRenderToScreen) {
            scene.render(ellapsedTime, deltaTime, null);
        } else {
            scene.render(ellapsedTime, deltaTime, writeTarget);
        }
    }

    public void setOpacity(@FloatRange(from=0.0, to=1.0) float value) {
        this.mOpacity = value;
    }
}

