/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.postprocessing.passes;

import android.opengl.GLES20;
import org.rajawali3d.cameras.Camera;
import org.rajawali3d.materials.Material;
import org.rajawali3d.materials.plugins.DepthMaterialPlugin;
import org.rajawali3d.postprocessing.APass;
import org.rajawali3d.postprocessing.IPass;
import org.rajawali3d.primitives.ScreenQuad;
import org.rajawali3d.renderer.RenderTarget;
import org.rajawali3d.renderer.Renderer;
import org.rajawali3d.scene.Scene;

public class DepthPass
extends APass {
    protected Scene mScene;
    protected Camera mCamera;
    protected Camera mOldCamera;
    protected DepthMaterialPlugin mDepthPlugin;

    public DepthPass(Scene scene, Camera camera) {
        this.mPassType = IPass.PassType.DEPTH;
        this.mScene = scene;
        this.mCamera = camera;
        this.mEnabled = true;
        this.mClear = true;
        this.mNeedsSwap = true;
        Material mat = new Material();
        this.mDepthPlugin = new DepthMaterialPlugin();
        mat.addPlugin(this.mDepthPlugin);
        this.setMaterial(mat);
    }

    @Override
    public void render(Scene scene, Renderer renderer, ScreenQuad screenQuad, RenderTarget writeTarget, RenderTarget readTarget, long ellapsedTime, double deltaTime) {
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.mDepthPlugin.setFarPlane((float)this.mCamera.getFarPlane());
        this.mOldCamera = this.mScene.getCamera();
        this.mScene.switchCamera(this.mCamera);
        this.mScene.render(ellapsedTime, deltaTime, writeTarget, this.mMaterial);
        this.mScene.switchCamera(this.mOldCamera);
    }
}

