/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.postprocessing.passes;

import android.opengl.GLES20;
import org.rajawali3d.R;
import org.rajawali3d.materials.Material;
import org.rajawali3d.materials.shaders.FragmentShader;
import org.rajawali3d.materials.shaders.VertexShader;
import org.rajawali3d.util.RawShaderLoader;

public class CopyPass
extends Material {
    public CopyPass() {
        this.mCustomVertexShader = new MinimalVertexShader();
        this.mCustomFragmentShader = new CopyFragmentShader();
    }

    public void setOpacity(float opacity) {
        ((CopyFragmentShader)this.mCustomFragmentShader).setOpacity(opacity);
    }

    private class CopyFragmentShader
    extends FragmentShader {
        private int muOpacityHandle;
        private float mOpacity;

        public CopyFragmentShader() {
            this.mNeedsBuild = false;
            this.mShaderString = RawShaderLoader.fetch(R.raw.copy_fragment_shader);
        }

        @Override
        public void setLocations(int programHandle) {
            super.setLocations(programHandle);
            this.muOpacityHandle = this.getUniformLocation(programHandle, "uOpacity");
        }

        @Override
        public void applyParams() {
            super.applyParams();
            GLES20.glUniform1f((int)this.muOpacityHandle, (float)this.mOpacity);
        }

        public void setOpacity(float opacity) {
            this.mOpacity = opacity;
        }
    }

    private class MinimalVertexShader
    extends VertexShader {
        public MinimalVertexShader() {
            this.mNeedsBuild = false;
            this.mShaderString = RawShaderLoader.fetch(R.raw.minimal_vertex_shader);
        }
    }
}

