/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.postprocessing.passes;

import android.graphics.Color;
import org.rajawali3d.R;
import org.rajawali3d.postprocessing.passes.EffectPass;

public class ColorThresholdPass
extends EffectPass {
    private float[] mLowerThreshold;
    private float[] mUpperThreshold;

    public ColorThresholdPass(int lowerThreshold, int upperThreshold) {
        this.createMaterial(R.raw.minimal_vertex_shader, R.raw.color_threshold_shader);
        this.mLowerThreshold = new float[]{(float)Color.red((int)lowerThreshold) / 255.0f, (float)Color.green((int)lowerThreshold) / 255.0f, (float)Color.blue((int)lowerThreshold) / 255.0f};
        this.mUpperThreshold = new float[]{(float)Color.red((int)upperThreshold) / 255.0f, (float)Color.green((int)upperThreshold) / 255.0f, (float)Color.blue((int)upperThreshold) / 255.0f};
    }

    @Override
    public void setShaderParams() {
        super.setShaderParams();
        this.mFragmentShader.setUniform3fv("uLowerThreshold", this.mLowerThreshold);
        this.mFragmentShader.setUniform3fv("uUpperThreshold", this.mUpperThreshold);
    }
}

