/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.postprocessing.passes;

import org.rajawali3d.R;
import org.rajawali3d.postprocessing.passes.EffectPass;

public class BlurPass
extends EffectPass {
    protected Direction mBlurDirection;
    protected float[] mDirection;
    protected float mRadius;
    protected float mResolution;

    public BlurPass(Direction direction, float radius, int screenWidth, int screenHeight) {
        float[] fArray;
        if (direction == Direction.HORIZONTAL) {
            float[] fArray2 = new float[2];
            fArray2[0] = 1.0f;
            fArray = fArray2;
            fArray2[1] = 0.0f;
        } else {
            float[] fArray3 = new float[2];
            fArray3[0] = 0.0f;
            fArray = fArray3;
            fArray3[1] = 1.0f;
        }
        this.mDirection = fArray;
        this.mRadius = radius;
        this.mBlurDirection = direction;
        this.setSize(screenWidth, screenHeight);
        this.createMaterial(R.raw.minimal_vertex_shader, R.raw.blur_fragment_shader);
    }

    @Override
    public void setShaderParams() {
        super.setShaderParams();
        this.mFragmentShader.setUniform2fv("uDirection", this.mDirection);
        this.mFragmentShader.setUniform1f("uRadius", this.mRadius);
        this.mFragmentShader.setUniform1f("uResolution", this.mResolution);
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.mResolution = this.mBlurDirection == Direction.HORIZONTAL ? (float)width : (float)height;
    }

    public static enum Direction {
        HORIZONTAL,
        VERTICAL;

    }
}

