/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.postprocessing.passes;

import org.rajawali3d.R;
import org.rajawali3d.materials.Material;
import org.rajawali3d.materials.textures.ATexture;
import org.rajawali3d.postprocessing.passes.EffectPass;

public class BlendPass
extends EffectPass {
    protected ATexture mBlendTexture;

    public BlendPass(BlendMode blendMode, ATexture blendTexture) {
        this.createMaterial(R.raw.minimal_vertex_shader, this.getFragmentShader(blendMode));
        this.mBlendTexture = blendTexture;
    }

    @Override
    public void setMaterial(Material material) {
        super.setMaterial(material);
        material.setTextureHandleForName("uBlendTexture");
    }

    protected int getFragmentShader(BlendMode blendMode) {
        switch (blendMode) {
            case ADD: {
                return R.raw.blend_add_fragment_shader;
            }
            case SCREEN: {
                return R.raw.blend_screen_fragment_shader;
            }
        }
        return R.raw.blend_add_fragment_shader;
    }

    @Override
    public void setShaderParams() {
        super.setShaderParams();
        this.mMaterial.bindTextureByName("uBlendTexture", 1, this.mBlendTexture);
    }

    public static enum BlendMode {
        ADD,
        SCREEN;

    }
}

