/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.postprocessing.materials;

import android.opengl.GLES20;
import org.rajawali3d.Object3D;
import org.rajawali3d.bounds.BoundingBox;
import org.rajawali3d.cameras.Camera;
import org.rajawali3d.lights.DirectionalLight;
import org.rajawali3d.materials.Material;
import org.rajawali3d.materials.plugins.ShadowMapMaterialPlugin;
import org.rajawali3d.materials.shaders.AShaderBase;
import org.rajawali3d.materials.shaders.FragmentShader;
import org.rajawali3d.materials.shaders.VertexShader;
import org.rajawali3d.materials.textures.ATexture;
import org.rajawali3d.math.Matrix4;
import org.rajawali3d.math.vector.Vector3;
import org.rajawali3d.scene.Scene;

public class ShadowMapMaterial
extends Material {
    private Scene mScene;
    private ShadowMapMaterialPlugin mMaterialPlugin;
    private ShadowMapVertexShader mVertexShader = new ShadowMapVertexShader();
    private DirectionalLight mLight;

    public ShadowMapMaterial() {
        this.mCustomVertexShader = this.mVertexShader;
        this.mCustomFragmentShader = new ShadowMapFragmentShader();
        this.mMaterialPlugin = new ShadowMapMaterialPlugin();
    }

    public ShadowMapMaterial(Camera camera, Scene scene, DirectionalLight light) {
        this();
        this.setCamera(camera);
        this.setScene(scene);
        this.setLight(light);
    }

    public void setCamera(Camera camera) {
        ((ShadowMapVertexShader)this.mCustomVertexShader).setCamera(camera);
    }

    public void setLight(DirectionalLight light) {
        ((ShadowMapVertexShader)this.mCustomVertexShader).setLight(light);
        this.mLight = light;
    }

    public void setScene(Scene scene) {
        this.mScene = scene;
        this.mScene.setShadowMapMaterial(this);
    }

    public void setShadowInfluence(float influence) {
        this.mMaterialPlugin.setShadowInfluence(influence);
    }

    public void setShadowMapTexture(ATexture shadowMapTexture) {
        this.mMaterialPlugin.setShadowMapTexture(shadowMapTexture);
    }

    @Override
    public void setCurrentObject(Object3D currentObject) {
    }

    @Override
    public void unsetCurrentObject(Object3D currentObject) {
    }

    public ShadowMapMaterialPlugin getMaterialPlugin() {
        return this.mMaterialPlugin;
    }

    @Override
    public void applyParams() {
        super.applyParams();
        this.mMaterialPlugin.setLightModelViewProjectionMatrix(this.mVertexShader.getLightViewProjectionMatrix());
        this.mMaterialPlugin.setLightDirection(this.mLight.getDirectionVector());
    }

    private final class ShadowMapFragmentShader
    extends FragmentShader {
        @Override
        public void initialize() {
            super.initialize();
        }

        @Override
        public void setLocations(int programHandle) {
            super.setLocations(programHandle);
        }

        @Override
        public void main() {
            this.GL_FRAG_COLOR.a().assign(1.0f);
            this.GL_FRAG_COLOR.r().assign(this.GL_FRAG_COORD.z());
            this.GL_FRAG_COLOR.g().assign(this.GL_FRAG_COORD.z());
            this.GL_FRAG_COLOR.b().assign(this.GL_FRAG_COORD.z());
        }

        @Override
        public void applyParams() {
            super.applyParams();
        }
    }

    private final class ShadowMapVertexShader
    extends VertexShader {
        private static final String U_MVP_LIGHT = "uMVPLight";
        private AShaderBase.RVec4 maPosition;
        private AShaderBase.RMat4 muLightMatrix;
        private AShaderBase.RMat4 muModelMatrix;
        private int muLightMatrixHandle;
        private float[] mLightMatrix = new float[16];
        private Camera mCamera;
        private Vector3[] mFrustumCorners;
        private DirectionalLight mLight;
        private Vector3 mFrustumCentroid = new Vector3();
        private Matrix4 mLightViewMatrix = new Matrix4();
        private Matrix4 mLightProjectionMatrix = new Matrix4();
        private Matrix4 mLightModelViewProjectionMatrix = new Matrix4();

        public ShadowMapVertexShader() {
            this.mFrustumCorners = new Vector3[8];
            for (int i = 0; i < 8; ++i) {
                this.mFrustumCorners[i] = new Vector3();
            }
        }

        @Override
        public void initialize() {
            super.initialize();
            this.muModelMatrix = (AShaderBase.RMat4)this.addUniform(AShaderBase.DefaultShaderVar.U_MODEL_MATRIX);
            this.muLightMatrix = (AShaderBase.RMat4)this.addUniform(U_MVP_LIGHT, AShaderBase.DataType.MAT4);
            this.maPosition = (AShaderBase.RVec4)this.addAttribute(AShaderBase.DefaultShaderVar.A_POSITION);
        }

        @Override
        public void main() {
            this.GL_POSITION.assign(this.muLightMatrix.multiply(this.muModelMatrix.multiply(this.maPosition)));
        }

        @Override
        public void setLocations(int programHandle) {
            super.setLocations(programHandle);
            this.muLightMatrixHandle = this.getUniformLocation(programHandle, U_MVP_LIGHT);
        }

        @Override
        public void applyParams() {
            super.applyParams();
            this.createLightViewProjectionMatrix(this.mLight).toFloatArray(this.mLightMatrix);
            GLES20.glUniformMatrix4fv((int)this.muLightMatrixHandle, (int)1, (boolean)false, (float[])this.mLightMatrix, (int)0);
        }

        private Matrix4 createLightViewProjectionMatrix(DirectionalLight light) {
            this.mCamera.getFrustumCorners(this.mFrustumCorners, true);
            this.mFrustumCentroid.setAll(0.0, 0.0, 0.0);
            for (int i = 0; i < 8; ++i) {
                this.mFrustumCentroid.add(this.mFrustumCorners[i]);
            }
            this.mFrustumCentroid.divide(8.0);
            BoundingBox lightBox = new BoundingBox(this.mFrustumCorners);
            double distance = this.mFrustumCentroid.distanceTo(lightBox.getMin());
            Vector3 lightDirection = light.getDirectionVector().clone();
            lightDirection.normalize();
            Vector3 lightPosition = Vector3.subtractAndCreate(this.mFrustumCentroid, Vector3.multiplyAndCreate(lightDirection, distance));
            this.mLightViewMatrix.setToLookAt(lightPosition, this.mFrustumCentroid, Vector3.Y);
            for (int i = 0; i < 8; ++i) {
                this.mFrustumCorners[i].multiply(this.mLightViewMatrix);
            }
            BoundingBox b = new BoundingBox(this.mFrustumCorners);
            this.mLightProjectionMatrix.setToOrthographic(b.getMin().x, b.getMax().x, b.getMin().y, b.getMax().y, -b.getMax().z, -b.getMin().z);
            this.mLightModelViewProjectionMatrix.setAll(this.mLightProjectionMatrix);
            this.mLightModelViewProjectionMatrix.multiply(this.mLightViewMatrix);
            return this.mLightModelViewProjectionMatrix;
        }

        public void setCamera(Camera camera) {
            this.mCamera = camera;
        }

        public void setLight(DirectionalLight light) {
            this.mLight = light;
        }

        public Matrix4 getLightViewProjectionMatrix() {
            return this.mLightModelViewProjectionMatrix;
        }
    }
}

