/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.postprocessing.effects;

import android.graphics.Bitmap;
import org.rajawali3d.cameras.Camera;
import org.rajawali3d.lights.DirectionalLight;
import org.rajawali3d.materials.textures.ATexture;
import org.rajawali3d.postprocessing.APostProcessingEffect;
import org.rajawali3d.postprocessing.materials.ShadowMapMaterial;
import org.rajawali3d.postprocessing.passes.ShadowPass;
import org.rajawali3d.renderer.RenderTarget;
import org.rajawali3d.renderer.Renderer;
import org.rajawali3d.scene.Scene;

public class ShadowEffect
extends APostProcessingEffect {
    private Scene mScene;
    private Camera mCamera;
    private DirectionalLight mLight;
    private int mShadowMapSize;
    private RenderTarget mShadowRenderTarget;
    private float mShadowInfluence;
    private ShadowMapMaterial mShadowMapMaterial;

    public ShadowEffect(Scene scene, Camera camera, DirectionalLight light, int shadowMapSize) {
        this.mScene = scene;
        this.mCamera = camera;
        this.mLight = light;
        this.mShadowMapSize = shadowMapSize;
    }

    public void setShadowInfluence(float influence) {
        this.mShadowInfluence = influence;
        if (this.mShadowMapMaterial != null) {
            this.mShadowMapMaterial.setShadowInfluence(influence);
        }
    }

    @Override
    public void initialize(Renderer renderer) {
        this.mShadowRenderTarget = new RenderTarget("shadowRT" + this.hashCode(), this.mShadowMapSize, this.mShadowMapSize, 0, 0, false, false, 3553, Bitmap.Config.ARGB_8888, ATexture.FilterType.LINEAR, ATexture.WrapType.CLAMP);
        renderer.addRenderTarget(this.mShadowRenderTarget);
        ShadowPass pass1 = new ShadowPass(ShadowPass.ShadowPassType.CREATE_SHADOW_MAP, this.mScene, this.mCamera, this.mLight, this.mShadowRenderTarget);
        this.addPass(pass1);
        ShadowPass pass2 = new ShadowPass(ShadowPass.ShadowPassType.APPLY_SHADOW_MAP, this.mScene, this.mCamera, this.mLight, this.mShadowRenderTarget);
        this.mShadowMapMaterial = pass1.getShadowMapMaterial();
        this.mShadowMapMaterial.setShadowInfluence(this.mShadowInfluence);
        pass2.setShadowMapMaterial(pass1.getShadowMapMaterial());
        this.addPass(pass2);
    }
}

