/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.postprocessing.effects;

import org.rajawali3d.cameras.Camera;
import org.rajawali3d.postprocessing.APostProcessingEffect;
import org.rajawali3d.postprocessing.passes.BlendPass;
import org.rajawali3d.postprocessing.passes.BlurPass;
import org.rajawali3d.postprocessing.passes.ColorThresholdPass;
import org.rajawali3d.postprocessing.passes.CopyToNewRenderTargetPass;
import org.rajawali3d.postprocessing.passes.RenderPass;
import org.rajawali3d.renderer.Renderer;
import org.rajawali3d.scene.Scene;

public class BloomEffect
extends APostProcessingEffect {
    private Scene mScene;
    private Camera mCamera;
    private int mWidth;
    private int mHeight;
    private int mLowerThreshold;
    private int mUpperThreshold;
    private BlendPass.BlendMode mBlendMode;

    public BloomEffect(Scene scene, Camera camera, int width, int height, int lowerThreshold, int upperThreshold, BlendPass.BlendMode blendMode) {
        this.mScene = scene;
        this.mCamera = camera;
        this.mWidth = width;
        this.mHeight = height;
        this.mLowerThreshold = lowerThreshold;
        this.mUpperThreshold = upperThreshold;
        this.mBlendMode = blendMode;
    }

    @Override
    public void initialize(Renderer renderer) {
        this.addPass(new ColorThresholdPass(this.mLowerThreshold, this.mUpperThreshold));
        this.addPass(new BlurPass(BlurPass.Direction.HORIZONTAL, 6.0f, this.mWidth, this.mHeight));
        this.addPass(new BlurPass(BlurPass.Direction.VERTICAL, 6.0f, this.mWidth, this.mHeight));
        CopyToNewRenderTargetPass copyPass = new CopyToNewRenderTargetPass("bloomPassTarget", renderer, this.mWidth, this.mHeight);
        this.addPass(copyPass);
        this.addPass(new RenderPass(this.mScene, this.mCamera, this.mScene.getBackgroundColor()));
        this.addPass(new BlendPass(this.mBlendMode, copyPass.getRenderTarget().getTexture()));
    }
}

