/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.postprocessing;

import android.graphics.Bitmap;
import android.opengl.GLES20;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.rajawali3d.materials.textures.ATexture;
import org.rajawali3d.postprocessing.IPass;
import org.rajawali3d.postprocessing.IPostProcessingComponent;
import org.rajawali3d.postprocessing.IPostProcessingEffect;
import org.rajawali3d.postprocessing.passes.CopyPass;
import org.rajawali3d.postprocessing.passes.EffectPass;
import org.rajawali3d.primitives.ScreenQuad;
import org.rajawali3d.renderer.RenderTarget;
import org.rajawali3d.renderer.Renderer;
import org.rajawali3d.scene.Scene;
import org.rajawali3d.scenegraph.IGraphNode;

public class PostProcessingManager {
    protected Renderer mRenderer;
    protected RenderTarget mRenderTarget1;
    protected RenderTarget mRenderTarget2;
    public RenderTarget mReadBuffer;
    public RenderTarget mWriteBuffer;
    protected List<IPostProcessingComponent> mComponents;
    protected List<IPass> mPasses;
    protected boolean mComponentsDirty = false;
    protected int mNumPasses;
    protected int mWidth;
    protected int mHeight;
    protected EffectPass mCopyPass;
    protected ScreenQuad mScreenQuad;
    protected Scene mScene;

    public PostProcessingManager(@NonNull Renderer renderer) {
        this(renderer, -1, -1);
    }

    public PostProcessingManager(@NonNull Renderer renderer, @FloatRange(from=0.0) double sampleFactor) {
        this(renderer, (int)(sampleFactor * (double)renderer.getViewportWidth()), (int)(sampleFactor * (double)renderer.getViewportHeight()));
    }

    public PostProcessingManager(@NonNull Renderer renderer, @IntRange(from=-1L) int width, @IntRange(from=-1L) int height) {
        this.mRenderer = renderer;
        if (width == -1 && height == -1) {
            width = this.mRenderer.getViewportWidth();
            height = this.mRenderer.getViewportHeight();
        }
        this.mWidth = width;
        this.mHeight = height;
        this.mScreenQuad = new ScreenQuad();
        this.mScene = new Scene(this.mRenderer, IGraphNode.GRAPH_TYPE.NONE);
        this.mRenderTarget1 = new RenderTarget("rt1" + this.hashCode(), width, height, 0, 0, false, false, 3553, Bitmap.Config.ARGB_8888, ATexture.FilterType.LINEAR, ATexture.WrapType.CLAMP);
        this.mRenderTarget2 = new RenderTarget("rt2" + this.hashCode(), width, height, 0, 0, false, false, 3553, Bitmap.Config.ARGB_8888, ATexture.FilterType.LINEAR, ATexture.WrapType.CLAMP);
        this.mWriteBuffer = this.mRenderTarget1;
        this.mReadBuffer = this.mRenderTarget2;
        this.mCopyPass = new EffectPass(new CopyPass());
        this.mCopyPass.setSize(this.mWidth, this.mHeight);
        this.mComponents = Collections.synchronizedList(new CopyOnWriteArrayList());
        this.mPasses = Collections.synchronizedList(new CopyOnWriteArrayList());
        this.mRenderer.addRenderTarget(this.mWriteBuffer);
        this.mRenderer.addRenderTarget(this.mReadBuffer);
        this.mScene.addChild(this.mScreenQuad);
        this.mRenderer.addScene(this.mScene);
    }

    public void swapBuffers() {
        RenderTarget tmp = this.mReadBuffer;
        this.mReadBuffer = this.mWriteBuffer;
        this.mWriteBuffer = tmp;
    }

    public void addPass(@NonNull IPass pass) {
        this.mComponents.add(pass);
        this.setComponentsDirty();
    }

    public void addEffect(@NonNull IPostProcessingEffect multiPass) {
        multiPass.initialize(this.mRenderer);
        this.mComponents.addAll(multiPass.getPasses());
        this.setComponentsDirty();
    }

    public void insertPass(@IntRange(from=0L) int index, @NonNull IPass pass) {
        this.mComponents.add(index, pass);
        this.setComponentsDirty();
    }

    public void insertEffect(@IntRange(from=0L) int index, @NonNull IPostProcessingEffect multiPass) {
        multiPass.initialize(this.mRenderer);
        this.mComponents.addAll(index, multiPass.getPasses());
        this.setComponentsDirty();
    }

    public void removePass(@NonNull IPass pass) {
        this.mComponents.remove(pass);
        this.setComponentsDirty();
    }

    public void removeEffect(@NonNull IPostProcessingEffect multiPass) {
        this.mComponents.removeAll(multiPass.getPasses());
        this.setComponentsDirty();
    }

    public void setSize(@IntRange(from=0L) int width, @IntRange(from=0L) int height) {
        this.mRenderTarget1.resize(width, height);
        this.mRenderTarget2.resize(width, height);
        this.mWidth = width;
        this.mHeight = height;
        for (IPass pass : this.mPasses) {
            if (pass.getRenderToScreen()) continue;
            this.checkAndUpdatePassDimensions(pass);
        }
        this.setComponentsDirty();
    }

    public void reset(@NonNull RenderTarget renderTarget) {
    }

    public void render(@IntRange(from=0L) long ellapsedTime, @FloatRange(from=0.0) double deltaTime) {
        if (this.mComponentsDirty) {
            this.updatePassesList();
            this.mComponentsDirty = false;
        }
        this.mWriteBuffer = this.mRenderTarget1;
        this.mReadBuffer = this.mRenderTarget2;
        boolean maskActive = false;
        for (int i = 0; i < this.mNumPasses; ++i) {
            IPass pass = this.mPasses.get(i);
            if (!pass.isEnabled()) continue;
            IPass.PassType type = pass.getPassType();
            if (pass.getRenderToScreen()) {
                this.mRenderer.clearOverrideViewportDimensions();
            } else {
                this.mRenderer.setOverrideViewportDimensions(pass.getWidth(), pass.getHeight());
            }
            boolean depthOrRenderPass = type == IPass.PassType.RENDER || type == IPass.PassType.DEPTH;
            Scene renderScene = depthOrRenderPass ? this.mRenderer.getCurrentScene() : this.mScene;
            pass.render(renderScene, this.mRenderer, this.mScreenQuad, this.mWriteBuffer, this.mReadBuffer, ellapsedTime, deltaTime);
            if (pass.needsSwap() && i < this.mNumPasses - 1) {
                if (maskActive) {
                    GLES20.glStencilFunc((int)517, (int)1, (int)-1);
                    this.mCopyPass.render(this.mScene, this.mRenderer, this.mScreenQuad, this.mWriteBuffer, this.mReadBuffer, ellapsedTime, deltaTime);
                    GLES20.glStencilFunc((int)514, (int)1, (int)-1);
                }
                this.swapBuffers();
            }
            if (type == IPass.PassType.MASK) {
                maskActive = true;
                continue;
            }
            if (type != IPass.PassType.CLEAR) continue;
            maskActive = false;
        }
        this.mRenderer.clearOverrideViewportDimensions();
    }

    @NonNull
    public ATexture getTexture() {
        return this.mWriteBuffer.getTexture();
    }

    private void updatePassesList() {
        this.mPasses.clear();
        for (int i = 0; i < this.mComponents.size(); ++i) {
            IPostProcessingComponent component = this.mComponents.get(i);
            if (component.getType() == IPostProcessingComponent.PostProcessingComponentType.PASS) {
                this.checkAndUpdatePassDimensions((IPass)component);
                this.mPasses.add((IPass)component);
                continue;
            }
            if (component.getType() != IPostProcessingComponent.PostProcessingComponentType.EFFECT) continue;
            IPostProcessingEffect effect = (IPostProcessingEffect)component;
            for (IPass pass : effect.getPasses()) {
                this.checkAndUpdatePassDimensions(pass);
            }
            this.mPasses.addAll(effect.getPasses());
        }
        this.mNumPasses = this.mPasses.size();
    }

    public boolean isEmpty() {
        return this.mComponents.isEmpty();
    }

    @NonNull
    public Scene getScene() {
        return this.mScene;
    }

    protected void setComponentsDirty() {
        this.mComponentsDirty = true;
    }

    protected void checkAndUpdatePassDimensions(IPass pass) {
        if (pass.getWidth() == -1 && pass.getHeight() == -1) {
            if (pass.getRenderToScreen()) {
                pass.setSize(this.mRenderer.getViewportWidth(), this.mRenderer.getViewportHeight());
            } else {
                pass.setSize(this.mWidth, this.mHeight);
            }
        }
    }
}

