/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.postprocessing;

import java.util.ArrayList;
import java.util.List;
import org.rajawali3d.postprocessing.IPass;
import org.rajawali3d.postprocessing.IPostProcessingComponent;
import org.rajawali3d.postprocessing.IPostProcessingEffect;
import org.rajawali3d.renderer.Renderer;

public abstract class APostProcessingEffect
implements IPostProcessingEffect {
    protected List<IPass> mPasses;
    protected boolean mEnabled;
    protected Renderer mRenderer;

    @Override
    public void removePass(IPass pass) {
        this.mPasses.remove(pass);
    }

    @Override
    public void removeAllPasses() {
        this.mPasses.clear();
    }

    @Override
    public IPass addPass(IPass pass) {
        if (this.mPasses == null) {
            this.mPasses = new ArrayList<IPass>();
        }
        this.mPasses.add(pass);
        return pass;
    }

    @Override
    public List<IPass> getPasses() {
        return this.mPasses;
    }

    @Override
    public boolean isEnabled() {
        return this.mEnabled;
    }

    @Override
    public IPostProcessingComponent.PostProcessingComponentType getType() {
        return IPostProcessingComponent.PostProcessingComponentType.MULTIPASS;
    }

    @Override
    public void setRenderToScreen(boolean renderToScreen) {
        for (IPass pass : this.mPasses) {
            pass.setRenderToScreen(false);
        }
        if (renderToScreen) {
            this.mPasses.get(this.mPasses.size() - 1).setRenderToScreen(true);
        }
    }
}

