/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.postprocessing;

import org.rajawali3d.materials.Material;
import org.rajawali3d.materials.MaterialManager;
import org.rajawali3d.postprocessing.IPass;
import org.rajawali3d.postprocessing.IPostProcessingComponent;
import org.rajawali3d.primitives.ScreenQuad;
import org.rajawali3d.renderer.RenderTarget;
import org.rajawali3d.renderer.Renderer;
import org.rajawali3d.scene.Scene;

public abstract class APass
implements IPass {
    protected boolean mEnabled;
    protected boolean mClear;
    protected boolean mNeedsSwap;
    protected IPass.PassType mPassType;
    protected Material mMaterial;
    protected boolean mRenderToScreen;
    protected int mWidth = -1;
    protected int mHeight = -1;

    @Override
    public boolean isEnabled() {
        return this.mEnabled;
    }

    @Override
    public boolean isClear() {
        return this.mClear;
    }

    @Override
    public boolean needsSwap() {
        return this.mNeedsSwap;
    }

    @Override
    public abstract void render(Scene var1, Renderer var2, ScreenQuad var3, RenderTarget var4, RenderTarget var5, long var6, double var8);

    @Override
    public IPass.PassType getPassType() {
        return this.mPassType;
    }

    @Override
    public IPostProcessingComponent.PostProcessingComponentType getType() {
        return IPostProcessingComponent.PostProcessingComponentType.PASS;
    }

    @Override
    public void setMaterial(Material material) {
        this.mMaterial = material;
        MaterialManager.getInstance().addMaterial(material);
    }

    @Override
    public void setRenderToScreen(boolean renderToScreen) {
        this.mRenderToScreen = renderToScreen;
    }

    @Override
    public boolean getRenderToScreen() {
        return this.mRenderToScreen;
    }

    @Override
    public void setWidth(int width) {
        this.mWidth = width;
    }

    @Override
    public int getWidth() {
        return this.mWidth;
    }

    @Override
    public void setHeight(int height) {
        this.mHeight = height;
    }

    @Override
    public int getHeight() {
        return this.mHeight;
    }

    @Override
    public void setSize(int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
    }
}

