/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.math.vector;

import android.support.annotation.NonNull;
import android.support.annotation.Size;
import org.rajawali3d.math.Matrix4;
import org.rajawali3d.math.Quaternion;

public class Vector3
implements Cloneable {
    public double x;
    public double y;
    public double z;
    @NonNull
    public static final Vector3 X = new Vector3(1.0, 0.0, 0.0);
    @NonNull
    public static final Vector3 Y = new Vector3(0.0, 1.0, 0.0);
    @NonNull
    public static final Vector3 Z = new Vector3(0.0, 0.0, 1.0);
    @NonNull
    public static final Vector3 NEG_X = new Vector3(-1.0, 0.0, 0.0);
    @NonNull
    public static final Vector3 NEG_Y = new Vector3(0.0, -1.0, 0.0);
    @NonNull
    public static final Vector3 NEG_Z = new Vector3(0.0, 0.0, -1.0);
    @NonNull
    public static final Vector3 ZERO = new Vector3(0.0, 0.0, 0.0);
    @NonNull
    public static final Vector3 ONE = new Vector3(1.0, 1.0, 1.0);
    private Vector3 mTmpVector3 = null;
    private Matrix4 mTmpMatrix4 = null;

    public Vector3() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
    }

    public Vector3(double from) {
        this.x = from;
        this.y = from;
        this.z = from;
    }

    public Vector3(@NonNull Vector3 from) {
        this.x = from.x;
        this.y = from.y;
        this.z = from.z;
    }

    public Vector3(@NonNull @Size(min=3L) String[] values) throws IllegalArgumentException, NumberFormatException {
        this(Float.parseFloat(values[0]), Float.parseFloat(values[1]), Float.parseFloat(values[2]));
    }

    public Vector3(@NonNull @Size(min=3L) double[] values) throws IllegalArgumentException {
        if (values.length < 3) {
            throw new IllegalArgumentException("Vector3 must be initialized with an array length of at least 3.");
        }
        this.x = values[0];
        this.y = values[1];
        this.z = values[2];
    }

    public Vector3(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3 setAll(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    @NonNull
    public Vector3 setAll(@NonNull Vector3 other) {
        this.x = other.x;
        this.y = other.y;
        this.z = other.z;
        return this;
    }

    @NonNull
    public Vector3 setAll(@NonNull Axis axis) {
        return this.setAll(Vector3.getAxisVector(axis));
    }

    @NonNull
    public Vector3 add(@NonNull Vector3 v) {
        this.x += v.x;
        this.y += v.y;
        this.z += v.z;
        return this;
    }

    @NonNull
    public Vector3 add(double x, double y, double z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    @NonNull
    public Vector3 add(double value) {
        this.x += value;
        this.y += value;
        this.z += value;
        return this;
    }

    @NonNull
    public Vector3 addAndSet(@NonNull Vector3 u, @NonNull Vector3 v) {
        this.x = u.x + v.x;
        this.y = u.y + v.y;
        this.z = u.z + v.z;
        return this;
    }

    @NonNull
    public static Vector3 addAndCreate(@NonNull Vector3 u, @NonNull Vector3 v) {
        return new Vector3(u.x + v.x, u.y + v.y, u.z + v.z);
    }

    @NonNull
    public Vector3 subtract(@NonNull Vector3 v) {
        this.x -= v.x;
        this.y -= v.y;
        this.z -= v.z;
        return this;
    }

    @NonNull
    public Vector3 subtract(double x, double y, double z) {
        this.x -= x;
        this.y -= y;
        this.z -= z;
        return this;
    }

    @NonNull
    public Vector3 subtract(double value) {
        this.x -= value;
        this.y -= value;
        this.z -= value;
        return this;
    }

    @NonNull
    public Vector3 subtractAndSet(@NonNull Vector3 u, @NonNull Vector3 v) {
        this.x = u.x - v.x;
        this.y = u.y - v.y;
        this.z = u.z - v.z;
        return this;
    }

    @NonNull
    public static Vector3 subtractAndCreate(@NonNull Vector3 u, @NonNull Vector3 v) {
        return new Vector3(u.x - v.x, u.y - v.y, u.z - v.z);
    }

    @NonNull
    public Vector3 multiply(double value) {
        this.x *= value;
        this.y *= value;
        this.z *= value;
        return this;
    }

    @NonNull
    public Vector3 multiply(@NonNull Vector3 v) {
        this.x *= v.x;
        this.y *= v.y;
        this.z *= v.z;
        return this;
    }

    @NonNull
    public Vector3 multiply(@NonNull @Size(min=16L) double[] matrix) {
        double vx = this.x;
        double vy = this.y;
        double vz = this.z;
        this.x = vx * matrix[0] + vy * matrix[4] + vz * matrix[8] + matrix[12];
        this.y = vx * matrix[1] + vy * matrix[5] + vz * matrix[9] + matrix[13];
        this.z = vx * matrix[2] + vy * matrix[6] + vz * matrix[10] + matrix[14];
        return this;
    }

    @NonNull
    public Vector3 multiply(@NonNull Matrix4 matrix) {
        return this.multiply(matrix.getDoubleValues());
    }

    @NonNull
    public Vector3 multiplyAndSet(@NonNull Vector3 u, @NonNull Vector3 v) {
        this.x = u.x * v.x;
        this.y = u.y * v.y;
        this.z = u.z * v.z;
        return this;
    }

    @NonNull
    public static Vector3 multiplyAndCreate(@NonNull Vector3 u, @NonNull Vector3 v) {
        return new Vector3(u.x * v.x, u.y * v.y, u.z * v.z);
    }

    @NonNull
    public static Vector3 multiplyAndCreate(@NonNull Vector3 v, double value) {
        return new Vector3(v.x * value, v.y * value, v.z * value);
    }

    @NonNull
    public Vector3 divide(double value) {
        this.x /= value;
        this.y /= value;
        this.z /= value;
        return this;
    }

    @NonNull
    public Vector3 divide(@NonNull Vector3 v) {
        this.x /= v.x;
        this.y /= v.y;
        this.z /= v.z;
        return this;
    }

    @NonNull
    public Vector3 divideAndSet(@NonNull Vector3 u, @NonNull Vector3 v) {
        this.x = u.x / v.x;
        this.y = u.y / v.y;
        this.z = u.z / v.z;
        return this;
    }

    @NonNull
    public Vector3 scaleAndSet(@NonNull Vector3 v, double b) {
        this.x = v.x * b;
        this.y = v.y * b;
        this.z = v.z * b;
        return this;
    }

    @NonNull
    public static Vector3 scaleAndCreate(@NonNull Vector3 u, double v) {
        return new Vector3(u.x * v, u.y * v, u.z * v);
    }

    @NonNull
    public Vector3 rotateBy(@NonNull Quaternion quaternion) {
        return this.setAll(quaternion.multiply(this));
    }

    @NonNull
    public Vector3 rotateX(double angle) {
        double cosRY = Math.cos(angle);
        double sinRY = Math.sin(angle);
        if (this.mTmpVector3 == null) {
            this.mTmpVector3 = new Vector3(this);
        } else {
            this.mTmpVector3.setAll(this.x, this.y, this.z);
        }
        this.y = this.mTmpVector3.y * cosRY - this.mTmpVector3.z * sinRY;
        this.z = this.mTmpVector3.y * sinRY + this.mTmpVector3.z * cosRY;
        return this;
    }

    @NonNull
    public Vector3 rotateY(double angle) {
        double cosRY = Math.cos(angle);
        double sinRY = Math.sin(angle);
        if (this.mTmpVector3 == null) {
            this.mTmpVector3 = new Vector3(this);
        } else {
            this.mTmpVector3.setAll(this.x, this.y, this.z);
        }
        this.x = this.mTmpVector3.x * cosRY + this.mTmpVector3.z * sinRY;
        this.z = this.mTmpVector3.x * -sinRY + this.mTmpVector3.z * cosRY;
        return this;
    }

    @NonNull
    public Vector3 rotateZ(double angle) {
        double cosRY = Math.cos(angle);
        double sinRY = Math.sin(angle);
        if (this.mTmpVector3 == null) {
            this.mTmpVector3 = new Vector3(this);
        } else {
            this.mTmpVector3.setAll(this.x, this.y, this.z);
        }
        this.x = this.mTmpVector3.x * cosRY - this.mTmpVector3.y * sinRY;
        this.y = this.mTmpVector3.x * sinRY + this.mTmpVector3.y * cosRY;
        return this;
    }

    public double normalize() {
        double mag = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        if (mag != 0.0 && mag != 1.0) {
            double mod = 1.0 / mag;
            this.x *= mod;
            this.y *= mod;
            this.z *= mod;
        }
        return mag;
    }

    public static void orthoNormalize(@NonNull @Size(min=2L) Vector3[] vecs) {
        for (int i = 0; i < vecs.length; ++i) {
            vecs[i].normalize();
            for (int j = i + 1; j < vecs.length; ++j) {
                vecs[j].subtract(Vector3.projectAndCreate(vecs[j], vecs[i]));
            }
        }
    }

    public static void orthoNormalize(@NonNull Vector3 v1, @NonNull Vector3 v2) {
        v1.normalize();
        v2.subtract(Vector3.projectAndCreate(v2, v1));
        v2.normalize();
    }

    @NonNull
    public Vector3 inverse() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    @NonNull
    public Vector3 invertAndCreate() {
        return new Vector3(-this.x, -this.y, -this.z);
    }

    public static double length(double x, double y, double z) {
        return Math.sqrt(Vector3.length2(x, y, z));
    }

    public static double length(@NonNull Vector3 v) {
        return Vector3.length(v.x, v.y, v.z);
    }

    public static double length2(@NonNull Vector3 v) {
        return Vector3.length2(v.x, v.y, v.z);
    }

    public static double length2(double x, double y, double z) {
        return x * x + y * y + z * z;
    }

    public double length() {
        return Vector3.length(this);
    }

    public double length2() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public double distanceTo(@NonNull Vector3 v) {
        double a = this.x - v.x;
        double b = this.y - v.y;
        double c = this.z - v.z;
        return Math.sqrt(a * a + b * b + c * c);
    }

    public double distanceTo(double x, double y, double z) {
        double a = this.x - x;
        double b = this.y - y;
        double c = this.z - z;
        return Math.sqrt(a * a + b * b + c * c);
    }

    public static double distanceTo(@NonNull Vector3 u, @NonNull Vector3 v) {
        double a = u.x - v.x;
        double b = u.y - v.y;
        double c = u.z - v.z;
        return Math.sqrt(a * a + b * b + c * c);
    }

    public static double distanceTo(double x1, double y1, double z1, double x2, double y2, double z2) {
        double a = x1 - x2;
        double b = y1 - y2;
        double c = z1 - z2;
        return Math.sqrt(a * a + b * b + c * c);
    }

    public double distanceTo2(@NonNull Vector3 v) {
        double a = this.x - v.x;
        double b = this.y - v.y;
        double c = this.z - v.z;
        return a * a + b * b + c * c;
    }

    public double distanceTo2(double x, double y, double z) {
        double a = this.x - x;
        double b = this.y - y;
        double c = this.z - z;
        return a * a + b * b + c * c;
    }

    public static double distanceTo2(@NonNull Vector3 u, @NonNull Vector3 v) {
        double a = u.x - v.x;
        double b = u.y - v.y;
        double c = u.z - v.z;
        return a * a + b * b + c * c;
    }

    public static double distanceTo2(double x1, double y1, double z1, double x2, double y2, double z2) {
        double a = x1 - x2;
        double b = y1 - y2;
        double c = z1 - z2;
        return a * a + b * b + c * c;
    }

    @NonNull
    public Vector3 absoluteValue() {
        this.x = Math.abs(this.x);
        this.y = Math.abs(this.y);
        this.z = Math.abs(this.z);
        return this;
    }

    @NonNull
    public Vector3 project(@NonNull Vector3 v) {
        double d = this.dot(v);
        double d_div = d / this.length2();
        return this.multiply(d_div);
    }

    @NonNull
    public Vector3 project(@NonNull @Size(min=16L) double[] matrix) {
        if (this.mTmpMatrix4 == null) {
            this.mTmpMatrix4 = new Matrix4(matrix);
        } else {
            this.mTmpMatrix4.setAll(matrix);
        }
        return this.project(this.mTmpMatrix4);
    }

    @NonNull
    public Vector3 project(@NonNull Matrix4 matrix) {
        return matrix.projectVector(this);
    }

    @NonNull
    public static Vector3 projectAndCreate(@NonNull Vector3 u, @NonNull Vector3 v) {
        double d = u.dot(v);
        double d_div = d / v.length2();
        return v.clone().multiply(d_div);
    }

    public double angle(@NonNull Vector3 v) {
        double dot = this.dot(v);
        return Math.toDegrees(Math.acos(dot /= this.length() * v.length()));
    }

    public static double dot(@NonNull Vector3 u, @NonNull Vector3 v) {
        return u.x * v.x + u.y * v.y + u.z * v.z;
    }

    public double dot(@NonNull Vector3 v) {
        return this.x * v.x + this.y * v.y + this.z * v.z;
    }

    public double dot(double x, double y, double z) {
        return this.x * x + this.y * y + this.z * z;
    }

    public static double dot(double x1, double y1, double z1, double x2, double y2, double z2) {
        return x1 * x2 + y1 * y2 + z1 * z2;
    }

    @NonNull
    public Vector3 cross(@NonNull Vector3 v) {
        if (this.mTmpVector3 == null) {
            this.mTmpVector3 = new Vector3(this);
        } else {
            this.mTmpVector3.setAll(this);
        }
        this.x = this.mTmpVector3.y * v.z - this.mTmpVector3.z * v.y;
        this.y = this.mTmpVector3.z * v.x - this.mTmpVector3.x * v.z;
        this.z = this.mTmpVector3.x * v.y - this.mTmpVector3.y * v.x;
        return this;
    }

    @NonNull
    public Vector3 cross(double x, double y, double z) {
        if (this.mTmpVector3 == null) {
            this.mTmpVector3 = new Vector3(this);
        } else {
            this.mTmpVector3.setAll(this);
        }
        this.x = this.mTmpVector3.y * z - this.mTmpVector3.z * y;
        this.y = this.mTmpVector3.z * x - this.mTmpVector3.x * z;
        this.z = this.mTmpVector3.x * y - this.mTmpVector3.y * x;
        return this;
    }

    @NonNull
    public Vector3 crossAndSet(@NonNull Vector3 u, @NonNull Vector3 v) {
        return this.setAll(u.y * v.z - u.z * v.y, u.z * v.x - u.x * v.z, u.x * v.y - u.y * v.x);
    }

    @NonNull
    public static Vector3 crossAndCreate(@NonNull Vector3 u, @NonNull Vector3 v) {
        return new Vector3(u.y * v.z - u.z * v.y, u.z * v.x - u.x * v.z, u.x * v.y - u.y * v.x);
    }

    @NonNull
    public Quaternion getRotationTo(@NonNull Vector3 direction) {
        return Quaternion.createFromRotationBetween(this, direction);
    }

    @NonNull
    public Vector3 lerp(@NonNull Vector3 target, double t) {
        return this.multiply(1.0 - t).add(target.x * t, target.y * t, target.z * t);
    }

    @NonNull
    public Vector3 lerpAndSet(@NonNull Vector3 from, @NonNull Vector3 to, double amount) {
        this.x = from.x + (to.x - from.x) * amount;
        this.y = from.y + (to.y - from.y) * amount;
        this.z = from.z + (to.z - from.z) * amount;
        return this;
    }

    @NonNull
    public static Vector3 lerpAndCreate(@NonNull Vector3 from, @NonNull Vector3 to, double amount) {
        Vector3 out = new Vector3();
        out.x = from.x + (to.x - from.x) * amount;
        out.y = from.y + (to.y - from.y) * amount;
        out.z = from.z + (to.z - from.z) * amount;
        return out;
    }

    @NonNull
    public Vector3 clone() {
        return new Vector3(this.x, this.y, this.z);
    }

    public boolean isUnit() {
        return this.isUnit(1.0E-8);
    }

    public boolean isUnit(double margin) {
        return Math.abs(this.length2() - 1.0) < margin * margin;
    }

    public boolean isZero() {
        return this.x == 0.0 && this.y == 0.0 && this.z == 0.0;
    }

    public boolean isZero(double margin) {
        return this.length2() <= margin * margin;
    }

    @NonNull
    public static Vector3 getAxisVector(@NonNull Axis axis) {
        switch (axis) {
            case X: {
                return X;
            }
            case Y: {
                return Y;
            }
            case Z: {
                return Z;
            }
        }
        throw new IllegalArgumentException("The specified Axis is not a valid choice.");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vector3 vector3 = (Vector3)o;
        return vector3.x == this.x && vector3.y == this.y && vector3.z == this.z;
    }

    public boolean equals(@NonNull Vector3 obj, double error) {
        return Math.abs(obj.x - this.x) <= error && Math.abs(obj.y - this.y) <= error && Math.abs(obj.z - this.z) <= error;
    }

    @NonNull
    @Size(min=3L)
    public double[] toArray(@Size(min=3L) double[] array) {
        if (array != null && array.length >= 3) {
            array[0] = this.x;
            array[1] = this.y;
            array[2] = this.z;
        }
        return array;
    }

    @NonNull
    @Size(value=3L)
    public double[] toArray() {
        return this.toArray(new double[3]);
    }

    @NonNull
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Vector3 <x, y, z>: <").append(this.x).append(", ").append(this.y).append(", ").append(this.z).append(">");
        return sb.toString();
    }

    public static enum Axis {
        X,
        Y,
        Z;

    }
}

