/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.math;

import org.rajawali3d.math.vector.Vector3;

public class Plane {
    private Vector3 mNormal;
    private double mD;

    public Plane() {
        this.mNormal = new Vector3();
    }

    public Plane(Vector3 point1, Vector3 point2, Vector3 point3) {
        this.set(point1, point2, point3);
    }

    public void set(Vector3 point1, Vector3 point2, Vector3 point3) {
        Vector3 v1 = new Vector3();
        Vector3 v2 = new Vector3();
        v1.subtractAndSet(point1, point2);
        v2.subtractAndSet(point3, point2);
        this.mNormal = v1.cross(v2);
        this.mNormal.normalize();
        this.mD = -point1.dot(this.mNormal);
    }

    public void setComponents(double x, double y, double z, double w) {
        this.mNormal.setAll(x, y, z);
        this.mD = w;
    }

    public double getDistanceTo(Vector3 point) {
        return this.mD + this.mNormal.dot(point);
    }

    public Vector3 getNormal() {
        return this.mNormal;
    }

    public double getD() {
        return this.mD;
    }

    public PlaneSide getPointSide(Vector3 point) {
        double distance = Vector3.dot(this.mNormal, point) + this.mD;
        if (distance == 0.0) {
            return PlaneSide.ONPLANE;
        }
        if (distance < 0.0) {
            return PlaneSide.BACK;
        }
        return PlaneSide.FRONT;
    }

    public boolean isFrontFacing(Vector3 direction) {
        double dot = Vector3.dot(this.mNormal, direction);
        return dot <= 0.0;
    }

    public void normalize() {
        double inverseNormalLength = 1.0 / this.mNormal.length();
        this.mNormal.multiply(inverseNormalLength);
        this.mD *= inverseNormalLength;
    }

    public static enum PlaneSide {
        BACK,
        ONPLANE,
        FRONT;

    }
}

