/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.math;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import java.util.Arrays;
import org.rajawali3d.math.Matrix;
import org.rajawali3d.math.Quaternion;
import org.rajawali3d.math.vector.Vector3;
import org.rajawali3d.util.ArrayUtils;

public final class Matrix4
implements Cloneable {
    public static final int M00 = 0;
    public static final int M01 = 4;
    public static final int M02 = 8;
    public static final int M03 = 12;
    public static final int M10 = 1;
    public static final int M11 = 5;
    public static final int M12 = 9;
    public static final int M13 = 13;
    public static final int M20 = 2;
    public static final int M21 = 6;
    public static final int M22 = 10;
    public static final int M23 = 14;
    public static final int M30 = 3;
    public static final int M31 = 7;
    public static final int M32 = 11;
    public static final int M33 = 15;
    @NonNull
    @Size(value=16L)
    private double[] m = new double[16];
    @NonNull
    @Size(value=16L)
    private double[] mTmp = new double[16];
    @NonNull
    @Size(value=16L)
    private float[] mFloat = new float[16];
    @NonNull
    private final Quaternion mQuat = new Quaternion();
    @NonNull
    private final Vector3 mVec1 = new Vector3();
    @NonNull
    private final Vector3 mVec2 = new Vector3();
    @NonNull
    private final Vector3 mVec3 = new Vector3();
    @Nullable
    private Matrix4 mMatrix;

    public Matrix4() {
        this.identity();
    }

    public Matrix4(@NonNull Matrix4 matrix) {
        this.setAll(matrix);
    }

    public Matrix4(@NonNull @Size(min=16L) double[] matrix) {
        this.setAll(matrix);
    }

    public Matrix4(@NonNull @Size(min=16L) float[] matrix) {
        this(ArrayUtils.convertFloatsToDoubles(matrix));
    }

    public Matrix4(@NonNull Quaternion quat) {
        this.setAll(quat);
    }

    @NonNull
    public Matrix4 setAll(@NonNull Matrix4 matrix) {
        matrix.toArray(this.m);
        return this;
    }

    @NonNull
    public Matrix4 setAll(@NonNull @Size(min=16L) double[] matrix) {
        System.arraycopy(matrix, 0, this.m, 0, 16);
        return this;
    }

    @NonNull
    public Matrix4 setAll(@NonNull @Size(min=16L) float[] matrix) {
        this.m[0] = matrix[0];
        this.m[1] = matrix[1];
        this.m[2] = matrix[2];
        this.m[3] = matrix[3];
        this.m[4] = matrix[4];
        this.m[5] = matrix[5];
        this.m[6] = matrix[6];
        this.m[7] = matrix[7];
        this.m[8] = matrix[8];
        this.m[9] = matrix[9];
        this.m[10] = matrix[10];
        this.m[11] = matrix[11];
        this.m[12] = matrix[12];
        this.m[13] = matrix[13];
        this.m[14] = matrix[14];
        this.m[15] = matrix[15];
        return this;
    }

    @NonNull
    public Matrix4 setAll(@NonNull Quaternion quat) {
        quat.toRotationMatrix(this.m);
        return this;
    }

    @NonNull
    public Matrix4 setAll(double w, double x, double y, double z) {
        return this.setAll(this.mQuat.setAll(w, x, y, z));
    }

    @NonNull
    public Matrix4 setAll(@NonNull Vector3 xAxis, @NonNull Vector3 yAxis, @NonNull Vector3 zAxis, @NonNull Vector3 pos) {
        this.m[0] = xAxis.x;
        this.m[4] = yAxis.x;
        this.m[8] = zAxis.x;
        this.m[12] = pos.x;
        this.m[1] = xAxis.y;
        this.m[5] = yAxis.y;
        this.m[9] = zAxis.y;
        this.m[13] = pos.y;
        this.m[2] = xAxis.z;
        this.m[6] = yAxis.z;
        this.m[10] = zAxis.z;
        this.m[14] = pos.z;
        this.m[3] = 0.0;
        this.m[7] = 0.0;
        this.m[11] = 0.0;
        this.m[15] = 1.0;
        return this;
    }

    @NonNull
    public Matrix4 setAll(@NonNull Vector3 position, @NonNull Vector3 scale, @NonNull Quaternion rotation) {
        double x2 = rotation.x * rotation.x;
        double y2 = rotation.y * rotation.y;
        double z2 = rotation.z * rotation.z;
        double xy = rotation.x * rotation.y;
        double xz = rotation.x * rotation.z;
        double yz = rotation.y * rotation.z;
        double wx = rotation.w * rotation.x;
        double wy = rotation.w * rotation.y;
        double wz = rotation.w * rotation.z;
        this.m[0] = scale.x * (1.0 - 2.0 * (y2 + z2));
        this.m[1] = 2.0 * scale.y * (xy - wz);
        this.m[2] = 2.0 * scale.z * (xz + wy);
        this.m[3] = 0.0;
        this.m[4] = 2.0 * scale.x * (xy + wz);
        this.m[5] = scale.y * (1.0 - 2.0 * (x2 + z2));
        this.m[6] = 2.0 * scale.z * (yz - wx);
        this.m[7] = 0.0;
        this.m[8] = 2.0 * scale.x * (xz - wy);
        this.m[9] = 2.0 * scale.y * (yz + wx);
        this.m[10] = scale.z * (1.0 - 2.0 * (x2 + y2));
        this.m[11] = 0.0;
        this.m[12] = position.x;
        this.m[13] = position.y;
        this.m[14] = position.z;
        this.m[15] = 1.0;
        return this;
    }

    @NonNull
    public Matrix4 identity() {
        this.m[0] = 1.0;
        this.m[1] = 0.0;
        this.m[2] = 0.0;
        this.m[3] = 0.0;
        this.m[4] = 0.0;
        this.m[5] = 1.0;
        this.m[6] = 0.0;
        this.m[7] = 0.0;
        this.m[8] = 0.0;
        this.m[9] = 0.0;
        this.m[10] = 1.0;
        this.m[11] = 0.0;
        this.m[12] = 0.0;
        this.m[13] = 0.0;
        this.m[14] = 0.0;
        this.m[15] = 1.0;
        return this;
    }

    @NonNull
    public Matrix4 zero() {
        for (int i = 0; i < 16; ++i) {
            this.m[i] = 0.0;
        }
        return this;
    }

    public double determinant() {
        return this.m[3] * this.m[6] * this.m[9] * this.m[12] - this.m[2] * this.m[7] * this.m[9] * this.m[12] - this.m[3] * this.m[5] * this.m[10] * this.m[12] + this.m[1] * this.m[7] * this.m[10] * this.m[12] + this.m[2] * this.m[5] * this.m[11] * this.m[12] - this.m[1] * this.m[6] * this.m[11] * this.m[12] - this.m[3] * this.m[6] * this.m[8] * this.m[13] + this.m[2] * this.m[7] * this.m[8] * this.m[13] + this.m[3] * this.m[4] * this.m[10] * this.m[13] - this.m[0] * this.m[7] * this.m[10] * this.m[13] - this.m[2] * this.m[4] * this.m[11] * this.m[13] + this.m[0] * this.m[6] * this.m[11] * this.m[13] + this.m[3] * this.m[5] * this.m[8] * this.m[14] - this.m[1] * this.m[7] * this.m[8] * this.m[14] - this.m[3] * this.m[4] * this.m[9] * this.m[14] + this.m[0] * this.m[7] * this.m[9] * this.m[14] + this.m[1] * this.m[4] * this.m[11] * this.m[14] - this.m[0] * this.m[5] * this.m[11] * this.m[14] - this.m[2] * this.m[5] * this.m[8] * this.m[15] + this.m[1] * this.m[6] * this.m[8] * this.m[15] + this.m[2] * this.m[4] * this.m[9] * this.m[15] - this.m[0] * this.m[6] * this.m[9] * this.m[15] - this.m[1] * this.m[4] * this.m[10] * this.m[15] + this.m[0] * this.m[5] * this.m[10] * this.m[15];
    }

    @NonNull
    public Matrix4 inverse() throws IllegalStateException {
        boolean success = Matrix.invertM(this.mTmp, 0, this.m, 0);
        if (!success) {
            throw new IllegalStateException("Matrix is singular and cannot be inverted.");
        }
        System.arraycopy(this.mTmp, 0, this.m, 0, 16);
        return this;
    }

    @NonNull
    public Matrix4 transpose() {
        Matrix.transposeM(this.mTmp, 0, this.m, 0);
        System.arraycopy(this.mTmp, 0, this.m, 0, 16);
        return this;
    }

    @NonNull
    public Matrix4 add(@NonNull Matrix4 matrix) {
        matrix.toArray(this.mTmp);
        this.m[0] = this.m[0] + this.mTmp[0];
        this.m[1] = this.m[1] + this.mTmp[1];
        this.m[2] = this.m[2] + this.mTmp[2];
        this.m[3] = this.m[3] + this.mTmp[3];
        this.m[4] = this.m[4] + this.mTmp[4];
        this.m[5] = this.m[5] + this.mTmp[5];
        this.m[6] = this.m[6] + this.mTmp[6];
        this.m[7] = this.m[7] + this.mTmp[7];
        this.m[8] = this.m[8] + this.mTmp[8];
        this.m[9] = this.m[9] + this.mTmp[9];
        this.m[10] = this.m[10] + this.mTmp[10];
        this.m[11] = this.m[11] + this.mTmp[11];
        this.m[12] = this.m[12] + this.mTmp[12];
        this.m[13] = this.m[13] + this.mTmp[13];
        this.m[14] = this.m[14] + this.mTmp[14];
        this.m[15] = this.m[15] + this.mTmp[15];
        return this;
    }

    @NonNull
    public Matrix4 subtract(@NonNull Matrix4 matrix) {
        matrix.toArray(this.mTmp);
        this.m[0] = this.m[0] - this.mTmp[0];
        this.m[1] = this.m[1] - this.mTmp[1];
        this.m[2] = this.m[2] - this.mTmp[2];
        this.m[3] = this.m[3] - this.mTmp[3];
        this.m[4] = this.m[4] - this.mTmp[4];
        this.m[5] = this.m[5] - this.mTmp[5];
        this.m[6] = this.m[6] - this.mTmp[6];
        this.m[7] = this.m[7] - this.mTmp[7];
        this.m[8] = this.m[8] - this.mTmp[8];
        this.m[9] = this.m[9] - this.mTmp[9];
        this.m[10] = this.m[10] - this.mTmp[10];
        this.m[11] = this.m[11] - this.mTmp[11];
        this.m[12] = this.m[12] - this.mTmp[12];
        this.m[13] = this.m[13] - this.mTmp[13];
        this.m[14] = this.m[14] - this.mTmp[14];
        this.m[15] = this.m[15] - this.mTmp[15];
        return this;
    }

    @NonNull
    public Matrix4 multiply(@NonNull Matrix4 matrix) {
        System.arraycopy(this.m, 0, this.mTmp, 0, 16);
        Matrix.multiplyMM(this.m, 0, this.mTmp, 0, matrix.getDoubleValues(), 0);
        return this;
    }

    @NonNull
    public Matrix4 leftMultiply(@NonNull Matrix4 matrix) {
        System.arraycopy(this.m, 0, this.mTmp, 0, 16);
        Matrix.multiplyMM(this.m, 0, matrix.getDoubleValues(), 0, this.mTmp, 0);
        return this;
    }

    @NonNull
    public Matrix4 multiply(double value) {
        int i = 0;
        while (i < this.m.length) {
            int n = i++;
            this.m[n] = this.m[n] * value;
        }
        return this;
    }

    @NonNull
    public Matrix4 translate(@NonNull Vector3 vec) {
        this.m[12] = this.m[12] + vec.x;
        this.m[13] = this.m[13] + vec.y;
        this.m[14] = this.m[14] + vec.z;
        return this;
    }

    @NonNull
    public Matrix4 translate(double x, double y, double z) {
        this.m[12] = this.m[12] + x;
        this.m[13] = this.m[13] + y;
        this.m[14] = this.m[14] + z;
        return this;
    }

    @NonNull
    public Matrix4 negTranslate(@NonNull Vector3 vec) {
        return this.translate(-vec.x, -vec.y, -vec.z);
    }

    @NonNull
    public Matrix4 scale(@NonNull Vector3 vec) {
        return this.scale(vec.x, vec.y, vec.z);
    }

    @NonNull
    public Matrix4 scale(double x, double y, double z) {
        Matrix.scaleM(this.m, 0, x, y, z);
        return this;
    }

    @NonNull
    public Matrix4 scale(double s) {
        return this.scale(s, s, s);
    }

    @NonNull
    public Matrix4 rotate(@NonNull Quaternion quat) {
        if (this.mMatrix == null) {
            this.mMatrix = quat.toRotationMatrix();
        } else {
            quat.toRotationMatrix(this.mMatrix);
        }
        return this.multiply(this.mMatrix);
    }

    @NonNull
    public Matrix4 rotate(@NonNull Vector3 axis, double angle) {
        return angle == 0.0 ? this : this.rotate(this.mQuat.fromAngleAxis(axis, angle));
    }

    @NonNull
    public Matrix4 rotate(@NonNull Vector3.Axis axis, double angle) {
        return angle == 0.0 ? this : this.rotate(this.mQuat.fromAngleAxis(axis, angle));
    }

    @NonNull
    public Matrix4 rotate(double x, double y, double z, double angle) {
        return angle == 0.0 ? this : this.rotate(this.mQuat.fromAngleAxis(x, y, z, angle));
    }

    @NonNull
    public Matrix4 rotate(@NonNull Vector3 v1, @NonNull Vector3 v2) {
        return this.rotate(this.mQuat.fromRotationBetween(v1, v2));
    }

    @NonNull
    public Matrix4 setTranslation(@NonNull Vector3 vec) {
        this.m[12] = vec.x;
        this.m[13] = vec.y;
        this.m[14] = vec.z;
        return this;
    }

    @NonNull
    public Matrix4 setCoordinateZoom(double zoom) {
        this.m[15] = zoom;
        return this;
    }

    public void rotateVector(@NonNull Vector3 vec) {
        double x = vec.x * this.m[0] + vec.y * this.m[4] + vec.z * this.m[8];
        double y = vec.x * this.m[1] + vec.y * this.m[5] + vec.z * this.m[9];
        double z = vec.x * this.m[2] + vec.y * this.m[6] + vec.z * this.m[10];
        vec.setAll(x, y, z);
    }

    @NonNull
    public Vector3 projectVector(@NonNull Vector3 vec) {
        double inv = 1.0 / (this.m[3] * vec.x + this.m[7] * vec.y + this.m[11] * vec.z + this.m[15]);
        vec.multiply(this.m);
        return vec.multiply(inv);
    }

    @NonNull
    public Vector3 projectAndCreateVector(@NonNull Vector3 vec) {
        Vector3 r = new Vector3(vec);
        return this.projectVector(r);
    }

    @NonNull
    public Matrix4 setTranslation(double x, double y, double z) {
        this.m[12] = x;
        this.m[13] = y;
        this.m[14] = z;
        return this;
    }

    @NonNull
    public Matrix4 lerp(@NonNull Matrix4 matrix, double t) {
        matrix.toArray(this.mTmp);
        for (int i = 0; i < 16; ++i) {
            this.m[i] = this.m[i] * (1.0 - t) + t * this.mTmp[i];
        }
        return this;
    }

    @NonNull
    public Matrix4 setToNormalMatrix() throws IllegalStateException {
        this.m[12] = 0.0;
        this.m[13] = 0.0;
        this.m[14] = 0.0;
        return this.inverse().transpose();
    }

    @NonNull
    public Matrix4 setToPerspective(double near, double far, double fov, double aspect) {
        this.identity();
        Matrix.perspectiveM(this.m, 0, fov, aspect, near, far);
        return this;
    }

    @NonNull
    public Matrix4 setToOrthographic2D(double x, double y, double width, double height) {
        return this.setToOrthographic(x, x + width, y, y + height, 0.0, 1.0);
    }

    @NonNull
    public Matrix4 setToOrthographic2D(double x, double y, double width, double height, double near, double far) {
        return this.setToOrthographic(x, x + width, y, y + height, near, far);
    }

    @NonNull
    public Matrix4 setToOrthographic(double left, double right, double bottom, double top, double near, double far) {
        Matrix.orthoM(this.m, 0, left, right, bottom, top, near, far);
        return this;
    }

    @NonNull
    public Matrix4 setToTranslation(@NonNull Vector3 vec) {
        this.identity();
        this.m[12] = vec.x;
        this.m[13] = vec.y;
        this.m[14] = vec.z;
        return this;
    }

    @NonNull
    public Matrix4 setToTranslation(double x, double y, double z) {
        this.identity();
        this.m[12] = x;
        this.m[13] = y;
        this.m[14] = z;
        return this;
    }

    @NonNull
    public Matrix4 setToScale(@NonNull Vector3 vec) {
        this.identity();
        this.m[0] = vec.x;
        this.m[5] = vec.y;
        this.m[10] = vec.z;
        return this;
    }

    @NonNull
    public Matrix4 setToScale(double x, double y, double z) {
        this.identity();
        this.m[0] = x;
        this.m[5] = y;
        this.m[10] = z;
        return this;
    }

    @NonNull
    public Matrix4 setToTranslationAndScaling(@NonNull Vector3 translation, @NonNull Vector3 scaling) {
        this.identity();
        this.m[12] = translation.x;
        this.m[13] = translation.y;
        this.m[14] = translation.z;
        this.m[0] = scaling.x;
        this.m[5] = scaling.y;
        this.m[10] = scaling.z;
        return this;
    }

    @NonNull
    public Matrix4 setToTranslationAndScaling(double tx, double ty, double tz, double sx, double sy, double sz) {
        this.identity();
        this.m[12] = tx;
        this.m[13] = ty;
        this.m[14] = tz;
        this.m[0] = sx;
        this.m[5] = sy;
        this.m[10] = sz;
        return this;
    }

    @NonNull
    public Matrix4 setToRotation(@NonNull Vector3 axis, double angle) {
        return angle == 0.0 ? this.identity() : this.setAll(this.mQuat.fromAngleAxis(axis, angle));
    }

    @NonNull
    public Matrix4 setToRotation(@NonNull Vector3.Axis axis, double angle) {
        return angle == 0.0 ? this.identity() : this.setAll(this.mQuat.fromAngleAxis(axis, angle));
    }

    @NonNull
    public Matrix4 setToRotation(double x, double y, double z, double angle) {
        return angle == 0.0 ? this.identity() : this.setAll(this.mQuat.fromAngleAxis(x, y, z, angle));
    }

    @NonNull
    public Matrix4 setToRotation(@NonNull Vector3 v1, @NonNull Vector3 v2) {
        return this.setAll(this.mQuat.fromRotationBetween(v1, v2));
    }

    @NonNull
    public Matrix4 setToRotation(double x1, double y1, double z1, double x2, double y2, double z2) {
        return this.setAll(this.mQuat.fromRotationBetween(x1, y1, z1, x2, y2, z2));
    }

    @NonNull
    public Matrix4 setToRotation(double yaw, double pitch, double roll) {
        return this.setAll(this.mQuat.fromEuler(yaw, pitch, roll));
    }

    @NonNull
    public Matrix4 setToLookAt(@NonNull Vector3 direction, @NonNull Vector3 up) {
        this.mQuat.lookAt(direction, up);
        return this.setAll(this.mQuat);
    }

    @NonNull
    public Matrix4 setToLookAt(@NonNull Vector3 position, @NonNull Vector3 target, @NonNull Vector3 up) {
        this.mVec1.subtractAndSet(target, position);
        return this.setToLookAt(this.mVec1, up);
    }

    @NonNull
    public Matrix4 setToWorld(@NonNull Vector3 position, @NonNull Vector3 forward, @NonNull Vector3 up) {
        this.mVec1.setAll(forward).normalize();
        this.mVec2.setAll(this.mVec1).cross(up).normalize();
        this.mVec3.setAll(this.mVec2).cross(this.mVec1).normalize();
        return this.setAll(this.mVec2, this.mVec3, this.mVec1.multiply(-1.0), position);
    }

    @NonNull
    public Vector3 getTranslation() {
        return this.getTranslation(new Vector3());
    }

    @NonNull
    public Vector3 getTranslation(Vector3 vec) {
        return vec.setAll(this.m[12], this.m[13], this.m[14]);
    }

    @NonNull
    public Vector3 getScaling() {
        double x = Math.sqrt(this.m[0] * this.m[0] + this.m[4] * this.m[4] + this.m[8] * this.m[8]);
        double y = Math.sqrt(this.m[1] * this.m[1] + this.m[5] * this.m[5] + this.m[9] * this.m[9]);
        double z = Math.sqrt(this.m[2] * this.m[2] + this.m[6] * this.m[6] + this.m[10] * this.m[10]);
        return new Vector3(x, y, z);
    }

    @NonNull
    public Vector3 getScaling(@NonNull Vector3 vec) {
        double x = Math.sqrt(this.m[0] * this.m[0] + this.m[4] * this.m[4] + this.m[8] * this.m[8]);
        double y = Math.sqrt(this.m[1] * this.m[1] + this.m[5] * this.m[5] + this.m[9] * this.m[9]);
        double z = Math.sqrt(this.m[2] * this.m[2] + this.m[6] * this.m[6] + this.m[10] * this.m[10]);
        return vec.setAll(x, y, z);
    }

    @NonNull
    public static Matrix4 createRotationMatrix(@NonNull Quaternion quat) {
        return new Matrix4(quat);
    }

    @NonNull
    public static Matrix4 createRotationMatrix(@NonNull Vector3 axis, double angle) {
        return new Matrix4().setToRotation(axis, angle);
    }

    @NonNull
    public static Matrix4 createRotationMatrix(@NonNull Vector3.Axis axis, double angle) {
        return new Matrix4().setToRotation(axis, angle);
    }

    @NonNull
    public static Matrix4 createRotationMatrix(double x, double y, double z, double angle) {
        return new Matrix4().setToRotation(x, y, z, angle);
    }

    @NonNull
    public static Matrix4 createRotationMatrix(double yaw, double pitch, double roll) {
        return new Matrix4().setToRotation(yaw, pitch, roll);
    }

    @NonNull
    public static Matrix4 createTranslationMatrix(@NonNull Vector3 vec) {
        return new Matrix4().translate(vec);
    }

    @NonNull
    public static Matrix4 createTranslationMatrix(double x, double y, double z) {
        return new Matrix4().translate(x, y, z);
    }

    @NonNull
    public static Matrix4 createScaleMatrix(@NonNull Vector3 vec) {
        return new Matrix4().setToScale(vec);
    }

    @NonNull
    public static Matrix4 createScaleMatrix(double x, double y, double z) {
        return new Matrix4().setToScale(x, y, z);
    }

    @NonNull
    @Size(value=16L)
    public float[] getFloatValues() {
        ArrayUtils.convertDoublesToFloats(this.m, this.mFloat);
        return this.mFloat;
    }

    @NonNull
    @Size(value=16L)
    public double[] getDoubleValues() {
        return this.m;
    }

    @NonNull
    public Matrix4 clone() {
        return new Matrix4(this);
    }

    public void toArray(@NonNull @Size(min=16L) double[] doubleArray) {
        System.arraycopy(this.m, 0, doubleArray, 0, 16);
    }

    public void toFloatArray(@NonNull @Size(min=16L) float[] floatArray) {
        floatArray[0] = (float)this.m[0];
        floatArray[1] = (float)this.m[1];
        floatArray[2] = (float)this.m[2];
        floatArray[3] = (float)this.m[3];
        floatArray[4] = (float)this.m[4];
        floatArray[5] = (float)this.m[5];
        floatArray[6] = (float)this.m[6];
        floatArray[7] = (float)this.m[7];
        floatArray[8] = (float)this.m[8];
        floatArray[9] = (float)this.m[9];
        floatArray[10] = (float)this.m[10];
        floatArray[11] = (float)this.m[11];
        floatArray[12] = (float)this.m[12];
        floatArray[13] = (float)this.m[13];
        floatArray[14] = (float)this.m[14];
        floatArray[15] = (float)this.m[15];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Matrix4 matrix4 = (Matrix4)o;
        return Arrays.equals(this.m, matrix4.m);
    }

    public int hashCode() {
        return Arrays.hashCode(this.m);
    }

    @NonNull
    public String toString() {
        return "[\n" + this.m[0] + "|" + this.m[4] + "|" + this.m[8] + "|" + this.m[12] + "]\n[" + this.m[1] + "|" + this.m[5] + "|" + this.m[9] + "|" + this.m[13] + "]\n[" + this.m[2] + "|" + this.m[6] + "|" + this.m[10] + "|" + this.m[14] + "]\n[" + this.m[3] + "|" + this.m[7] + "|" + this.m[11] + "|" + this.m[15] + "]\n";
    }
}

