/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.math;

public class Matrix {
    private static final double[] sTemp = new double[32];

    public static void multiplyMM(double[] result, int resultOffset, double[] lhs, int lhsOffset, double[] rhs, int rhsOffset) {
        String message = null;
        if (result == null) {
            message = "Result matrix can not be null.";
        } else if (lhs == null) {
            message = "Left hand side matrix can not be null.";
        } else if (rhs == null) {
            message = "Right hand side matrix can not be null.";
        } else if (resultOffset + 16 > result.length) {
            message = "Specified result offset would overflow the passed result matrix.";
        } else if (lhsOffset + 16 > lhs.length) {
            message = "Specified left hand side offset would overflow the passed lhs matrix.";
        } else if (rhsOffset + 16 > rhs.length) {
            message = "Specified right hand side offset would overflow the passed rhs matrix.";
        }
        if (message != null) {
            throw new IllegalArgumentException(message);
        }
        double sum = 0.0;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                sum = 0.0;
                for (int k = 0; k < 4; ++k) {
                    sum += lhs[i + 4 * k + lhsOffset] * rhs[4 * j + k + rhsOffset];
                }
                result[i + 4 * j + resultOffset] = sum;
            }
        }
    }

    public static void multiplyMV(double[] resultVec, int resultVecOffset, double[] lhsMat, int lhsMatOffset, double[] rhsVec, int rhsVecOffset) {
        String message = null;
        if (resultVec == null) {
            message = "Result vector can not be null.";
        } else if (lhsMat == null) {
            message = "Left hand side matrix can not be null.";
        } else if (rhsVec == null) {
            message = "Right hand side vector can not be null.";
        } else if (resultVecOffset + 4 > resultVec.length) {
            message = "Specified result offset would overflow the passed result vector.";
        } else if (lhsMatOffset + 16 > lhsMat.length) {
            message = "Specified left hand side offset would overflow the passed lhs matrix.";
        } else if (rhsVecOffset + 4 > rhsVec.length) {
            message = "Specified right hand side offset would overflow the passed rhs vector.";
        }
        if (message != null) {
            throw new IllegalArgumentException(message);
        }
        double sum = 0.0;
        for (int i = 0; i < 4; ++i) {
            sum = 0.0;
            for (int k = 0; k < 4; ++k) {
                sum += lhsMat[i + 4 * k + lhsMatOffset] * rhsVec[k + rhsVecOffset];
            }
            resultVec[i + resultVecOffset] = sum;
        }
    }

    public static void transposeM(double[] mTrans, int mTransOffset, double[] m, int mOffset) {
        for (int i = 0; i < 4; ++i) {
            int mBase = i * 4 + mOffset;
            mTrans[i + mTransOffset] = m[mBase];
            mTrans[i + 4 + mTransOffset] = m[mBase + 1];
            mTrans[i + 8 + mTransOffset] = m[mBase + 2];
            mTrans[i + 12 + mTransOffset] = m[mBase + 3];
        }
    }

    public static boolean invertM(double[] mInv, int mInvOffset, double[] m, int mOffset) {
        double src0 = m[mOffset + 0];
        double src4 = m[mOffset + 1];
        double src8 = m[mOffset + 2];
        double src12 = m[mOffset + 3];
        double src1 = m[mOffset + 4];
        double src5 = m[mOffset + 5];
        double src9 = m[mOffset + 6];
        double src13 = m[mOffset + 7];
        double src2 = m[mOffset + 8];
        double src6 = m[mOffset + 9];
        double src10 = m[mOffset + 10];
        double src14 = m[mOffset + 11];
        double src3 = m[mOffset + 12];
        double src7 = m[mOffset + 13];
        double src11 = m[mOffset + 14];
        double src15 = m[mOffset + 15];
        double atmp0 = src10 * src15;
        double atmp1 = src11 * src14;
        double atmp2 = src9 * src15;
        double atmp3 = src11 * src13;
        double atmp4 = src9 * src14;
        double atmp5 = src10 * src13;
        double atmp6 = src8 * src15;
        double atmp7 = src11 * src12;
        double atmp8 = src8 * src14;
        double atmp9 = src10 * src12;
        double atmp10 = src8 * src13;
        double atmp11 = src9 * src12;
        double dst0 = atmp0 * src5 + atmp3 * src6 + atmp4 * src7 - (atmp1 * src5 + atmp2 * src6 + atmp5 * src7);
        double dst1 = atmp1 * src4 + atmp6 * src6 + atmp9 * src7 - (atmp0 * src4 + atmp7 * src6 + atmp8 * src7);
        double dst2 = atmp2 * src4 + atmp7 * src5 + atmp10 * src7 - (atmp3 * src4 + atmp6 * src5 + atmp11 * src7);
        double dst3 = atmp5 * src4 + atmp8 * src5 + atmp11 * src6 - (atmp4 * src4 + atmp9 * src5 + atmp10 * src6);
        double dst4 = atmp1 * src1 + atmp2 * src2 + atmp5 * src3 - (atmp0 * src1 + atmp3 * src2 + atmp4 * src3);
        double dst5 = atmp0 * src0 + atmp7 * src2 + atmp8 * src3 - (atmp1 * src0 + atmp6 * src2 + atmp9 * src3);
        double dst6 = atmp3 * src0 + atmp6 * src1 + atmp11 * src3 - (atmp2 * src0 + atmp7 * src1 + atmp10 * src3);
        double dst7 = atmp4 * src0 + atmp9 * src1 + atmp10 * src2 - (atmp5 * src0 + atmp8 * src1 + atmp11 * src2);
        double btmp0 = src2 * src7;
        double btmp1 = src3 * src6;
        double btmp2 = src1 * src7;
        double btmp3 = src3 * src5;
        double btmp4 = src1 * src6;
        double btmp5 = src2 * src5;
        double btmp6 = src0 * src7;
        double btmp7 = src3 * src4;
        double btmp8 = src0 * src6;
        double btmp9 = src2 * src4;
        double btmp10 = src0 * src5;
        double btmp11 = src1 * src4;
        double dst8 = btmp0 * src13 + btmp3 * src14 + btmp4 * src15 - (btmp1 * src13 + btmp2 * src14 + btmp5 * src15);
        double dst9 = btmp1 * src12 + btmp6 * src14 + btmp9 * src15 - (btmp0 * src12 + btmp7 * src14 + btmp8 * src15);
        double dst10 = btmp2 * src12 + btmp7 * src13 + btmp10 * src15 - (btmp3 * src12 + btmp6 * src13 + btmp11 * src15);
        double dst11 = btmp5 * src12 + btmp8 * src13 + btmp11 * src14 - (btmp4 * src12 + btmp9 * src13 + btmp10 * src14);
        double dst12 = btmp2 * src10 + btmp5 * src11 + btmp1 * src9 - (btmp4 * src11 + btmp0 * src9 + btmp3 * src10);
        double dst13 = btmp8 * src11 + btmp0 * src8 + btmp7 * src10 - (btmp6 * src10 + btmp9 * src11 + btmp1 * src8);
        double dst14 = btmp6 * src9 + btmp11 * src11 + btmp3 * src8 - (btmp10 * src11 + btmp2 * src8 + btmp7 * src9);
        double dst15 = btmp10 * src10 + btmp4 * src8 + btmp9 * src9 - (btmp8 * src9 + btmp11 * src10 + btmp5 * src8);
        double det = src0 * dst0 + src1 * dst1 + src2 * dst2 + src3 * dst3;
        if (det == 0.0) {
            return false;
        }
        double invdet = 1.0 / det;
        mInv[mInvOffset] = dst0 * invdet;
        mInv[1 + mInvOffset] = dst1 * invdet;
        mInv[2 + mInvOffset] = dst2 * invdet;
        mInv[3 + mInvOffset] = dst3 * invdet;
        mInv[4 + mInvOffset] = dst4 * invdet;
        mInv[5 + mInvOffset] = dst5 * invdet;
        mInv[6 + mInvOffset] = dst6 * invdet;
        mInv[7 + mInvOffset] = dst7 * invdet;
        mInv[8 + mInvOffset] = dst8 * invdet;
        mInv[9 + mInvOffset] = dst9 * invdet;
        mInv[10 + mInvOffset] = dst10 * invdet;
        mInv[11 + mInvOffset] = dst11 * invdet;
        mInv[12 + mInvOffset] = dst12 * invdet;
        mInv[13 + mInvOffset] = dst13 * invdet;
        mInv[14 + mInvOffset] = dst14 * invdet;
        mInv[15 + mInvOffset] = dst15 * invdet;
        return true;
    }

    public static void orthoM(double[] m, int mOffset, double left, double right, double bottom, double top, double near, double far) {
        if (left == right) {
            throw new IllegalArgumentException("left == right");
        }
        if (bottom == top) {
            throw new IllegalArgumentException("bottom == top");
        }
        if (near == far) {
            throw new IllegalArgumentException("near == far");
        }
        double r_width = 1.0 / (right - left);
        double r_height = 1.0 / (top - bottom);
        double r_depth = 1.0 / (far - near);
        double x = 2.0 * r_width;
        double y = 2.0 * r_height;
        double z = -2.0 * r_depth;
        double tx = -(right + left) * r_width;
        double ty = -(top + bottom) * r_height;
        double tz = -(far + near) * r_depth;
        m[mOffset + 0] = x;
        m[mOffset + 5] = y;
        m[mOffset + 10] = z;
        m[mOffset + 12] = tx;
        m[mOffset + 13] = ty;
        m[mOffset + 14] = tz;
        m[mOffset + 15] = 1.0;
        m[mOffset + 1] = 0.0;
        m[mOffset + 2] = 0.0;
        m[mOffset + 3] = 0.0;
        m[mOffset + 4] = 0.0;
        m[mOffset + 6] = 0.0;
        m[mOffset + 7] = 0.0;
        m[mOffset + 8] = 0.0;
        m[mOffset + 9] = 0.0;
        m[mOffset + 11] = 0.0;
    }

    public static void frustumM(double[] m, int offset, double left, double right, double bottom, double top, double near, double far) {
        if (left == right) {
            throw new IllegalArgumentException("left == right");
        }
        if (top == bottom) {
            throw new IllegalArgumentException("top == bottom");
        }
        if (near == far) {
            throw new IllegalArgumentException("near == far");
        }
        if (near <= 0.0) {
            throw new IllegalArgumentException("near <= 0.0");
        }
        if (far <= 0.0) {
            throw new IllegalArgumentException("far <= 0.0");
        }
        double r_width = 1.0 / (right - left);
        double r_height = 1.0 / (top - bottom);
        double r_depth = 1.0 / (near - far);
        double x = 2.0 * (near * r_width);
        double y = 2.0 * (near * r_height);
        double A = (right + left) * r_width;
        double B = (top + bottom) * r_height;
        double C = (far + near) * r_depth;
        double D = 2.0 * (far * near * r_depth);
        m[offset + 0] = x;
        m[offset + 5] = y;
        m[offset + 8] = A;
        m[offset + 9] = B;
        m[offset + 10] = C;
        m[offset + 14] = D;
        m[offset + 11] = -1.0;
        m[offset + 1] = 0.0;
        m[offset + 2] = 0.0;
        m[offset + 3] = 0.0;
        m[offset + 4] = 0.0;
        m[offset + 6] = 0.0;
        m[offset + 7] = 0.0;
        m[offset + 12] = 0.0;
        m[offset + 13] = 0.0;
        m[offset + 15] = 0.0;
    }

    public static void perspectiveM(double[] m, int offset, double fovy, double aspect, double zNear, double zFar) {
        double f = 1.0 / Math.tan(fovy * (Math.PI / 360));
        double rangeReciprocal = 1.0 / (zNear - zFar);
        m[offset + 0] = f / aspect;
        m[offset + 1] = 0.0;
        m[offset + 2] = 0.0;
        m[offset + 3] = 0.0;
        m[offset + 4] = 0.0;
        m[offset + 5] = f;
        m[offset + 6] = 0.0;
        m[offset + 7] = 0.0;
        m[offset + 8] = 0.0;
        m[offset + 9] = 0.0;
        m[offset + 10] = (zFar + zNear) * rangeReciprocal;
        m[offset + 11] = -1.0;
        m[offset + 12] = 0.0;
        m[offset + 13] = 0.0;
        m[offset + 14] = 2.0 * zFar * zNear * rangeReciprocal;
        m[offset + 15] = 0.0;
    }

    public static double length(double x, double y, double z) {
        return Math.sqrt(x * x + y * y + z * z);
    }

    public static void setIdentityM(double[] sm, int smOffset) {
        int i;
        for (i = 0; i < 16; ++i) {
            sm[smOffset + i] = 0.0;
        }
        for (i = 0; i < 16; i += 5) {
            sm[smOffset + i] = 1.0;
        }
    }

    public static void scaleM(double[] sm, int smOffset, double[] m, int mOffset, double x, double y, double z) {
        for (int i = 0; i < 4; ++i) {
            int smi = smOffset + i;
            int mi = mOffset + i;
            sm[smi] = m[mi] * x;
            sm[4 + smi] = m[4 + mi] * y;
            sm[8 + smi] = m[8 + mi] * z;
            sm[12 + smi] = m[12 + mi];
        }
    }

    public static void scaleM(double[] m, int mOffset, double x, double y, double z) {
        for (int i = 0; i < 4; ++i) {
            int mi;
            int n = mi = mOffset + i;
            m[n] = m[n] * x;
            int n2 = 4 + mi;
            m[n2] = m[n2] * y;
            int n3 = 8 + mi;
            m[n3] = m[n3] * z;
        }
    }

    public static void translateM(double[] tm, int tmOffset, double[] m, int mOffset, double x, double y, double z) {
        int i;
        for (i = 0; i < 12; ++i) {
            tm[tmOffset + i] = m[mOffset + i];
        }
        for (i = 0; i < 4; ++i) {
            int tmi = tmOffset + i;
            int mi = mOffset + i;
            tm[12 + tmi] = m[mi] * x + m[4 + mi] * y + m[8 + mi] * z + m[12 + mi];
        }
    }

    public static void translateM(double[] m, int mOffset, double x, double y, double z) {
        for (int i = 0; i < 4; ++i) {
            int mi = mOffset + i;
            int n = 12 + mi;
            m[n] = m[n] + (m[mi] * x + m[4 + mi] * y + m[8 + mi] * z);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rotateM(double[] rm, int rmOffset, double[] m, int mOffset, double a, double x, double y, double z) {
        double[] dArray = sTemp;
        synchronized (sTemp) {
            Matrix.setRotateM(sTemp, 0, a, x, y, z);
            Matrix.multiplyMM(rm, rmOffset, m, mOffset, sTemp, 0);
            // ** MonitorExit[var12_8] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rotateM(double[] m, int mOffset, double a, double x, double y, double z) {
        double[] dArray = sTemp;
        synchronized (sTemp) {
            Matrix.setRotateM(sTemp, 0, a, x, y, z);
            Matrix.multiplyMM(sTemp, 16, m, mOffset, sTemp, 0);
            System.arraycopy(sTemp, 16, m, mOffset, 16);
            // ** MonitorExit[var10_6] (shouldn't be in output)
            return;
        }
    }

    public static void setRotateM(double[] rm, int rmOffset, double a, double x, double y, double z) {
        rm[rmOffset + 3] = 0.0;
        rm[rmOffset + 7] = 0.0;
        rm[rmOffset + 11] = 0.0;
        rm[rmOffset + 12] = 0.0;
        rm[rmOffset + 13] = 0.0;
        rm[rmOffset + 14] = 0.0;
        rm[rmOffset + 15] = 1.0;
        double s = Math.sin(a *= Math.PI / 180);
        double c = Math.cos(a);
        if (1.0 == x && 0.0 == y && 0.0 == z) {
            rm[rmOffset + 5] = c;
            rm[rmOffset + 10] = c;
            rm[rmOffset + 6] = s;
            rm[rmOffset + 9] = -s;
            rm[rmOffset + 1] = 0.0;
            rm[rmOffset + 2] = 0.0;
            rm[rmOffset + 4] = 0.0;
            rm[rmOffset + 8] = 0.0;
            rm[rmOffset + 0] = 1.0;
        } else if (0.0 == x && 1.0 == y && 0.0 == z) {
            rm[rmOffset + 0] = c;
            rm[rmOffset + 10] = c;
            rm[rmOffset + 8] = s;
            rm[rmOffset + 2] = -s;
            rm[rmOffset + 1] = 0.0;
            rm[rmOffset + 4] = 0.0;
            rm[rmOffset + 6] = 0.0;
            rm[rmOffset + 9] = 0.0;
            rm[rmOffset + 5] = 1.0;
        } else if (0.0 == x && 0.0 == y && 1.0 == z) {
            rm[rmOffset + 0] = c;
            rm[rmOffset + 5] = c;
            rm[rmOffset + 1] = s;
            rm[rmOffset + 4] = -s;
            rm[rmOffset + 2] = 0.0;
            rm[rmOffset + 6] = 0.0;
            rm[rmOffset + 8] = 0.0;
            rm[rmOffset + 9] = 0.0;
            rm[rmOffset + 10] = 1.0;
        } else {
            double len = Matrix.length(x, y, z);
            if (1.0 != len) {
                double recipLen = 1.0 / len;
                x *= recipLen;
                y *= recipLen;
                z *= recipLen;
            }
            double nc = 1.0 - c;
            double xy = x * y;
            double yz = y * z;
            double zx = z * x;
            double xs = x * s;
            double ys = y * s;
            double zs = z * s;
            rm[rmOffset + 0] = x * x * nc + c;
            rm[rmOffset + 4] = xy * nc - zs;
            rm[rmOffset + 8] = zx * nc + ys;
            rm[rmOffset + 1] = xy * nc + zs;
            rm[rmOffset + 5] = y * y * nc + c;
            rm[rmOffset + 9] = yz * nc - xs;
            rm[rmOffset + 2] = zx * nc - ys;
            rm[rmOffset + 6] = yz * nc + xs;
            rm[rmOffset + 10] = z * z * nc + c;
        }
    }

    public static void setRotateEulerM(double[] rm, int rmOffset, double x, double y, double z) {
        double cx = Math.cos(x *= Math.PI / 180);
        double sx = Math.sin(x);
        double cy = Math.cos(y *= Math.PI / 180);
        double sy = Math.sin(y);
        double cz = Math.cos(z *= Math.PI / 180);
        double sz = Math.sin(z);
        double cxsy = cx * sy;
        double sxsy = sx * sy;
        rm[rmOffset + 0] = cy * cz;
        rm[rmOffset + 1] = -cy * sz;
        rm[rmOffset + 2] = sy;
        rm[rmOffset + 3] = 0.0;
        rm[rmOffset + 4] = cxsy * cz + cx * sz;
        rm[rmOffset + 5] = -cxsy * sz + cx * cz;
        rm[rmOffset + 6] = -sx * cy;
        rm[rmOffset + 7] = 0.0;
        rm[rmOffset + 8] = -sxsy * cz + sx * sz;
        rm[rmOffset + 9] = sxsy * sz + sx * cz;
        rm[rmOffset + 10] = cx * cy;
        rm[rmOffset + 11] = 0.0;
        rm[rmOffset + 12] = 0.0;
        rm[rmOffset + 13] = 0.0;
        rm[rmOffset + 14] = 0.0;
        rm[rmOffset + 15] = 1.0;
    }

    public static void setLookAtM(double[] rm, int rmOffset, double eyeX, double eyeY, double eyeZ, double centerX, double centerY, double centerZ, double upX, double upY, double upZ) {
        double fx = centerX - eyeX;
        double fy = centerY - eyeY;
        double fz = centerZ - eyeZ;
        double rlf = 1.0 / Matrix.length(fx, fy, fz);
        double sx = (fy *= rlf) * upZ - (fz *= rlf) * upY;
        double sy = fz * upX - (fx *= rlf) * upZ;
        double sz = fx * upY - fy * upX;
        double rls = 1.0 / Matrix.length(sx, sy, sz);
        double ux = (sy *= rls) * fz - (sz *= rls) * fy;
        double uy = sz * fx - (sx *= rls) * fz;
        double uz = sx * fy - sy * fx;
        rm[rmOffset + 0] = sx;
        rm[rmOffset + 1] = ux;
        rm[rmOffset + 2] = -fx;
        rm[rmOffset + 3] = 0.0;
        rm[rmOffset + 4] = sy;
        rm[rmOffset + 5] = uy;
        rm[rmOffset + 6] = -fy;
        rm[rmOffset + 7] = 0.0;
        rm[rmOffset + 8] = sz;
        rm[rmOffset + 9] = uz;
        rm[rmOffset + 10] = -fz;
        rm[rmOffset + 11] = 0.0;
        rm[rmOffset + 12] = 0.0;
        rm[rmOffset + 13] = 0.0;
        rm[rmOffset + 14] = 0.0;
        rm[rmOffset + 15] = 1.0;
        Matrix.translateM(rm, rmOffset, -eyeX, -eyeY, -eyeZ);
    }
}

