/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.math;

public class MathUtil {
    public static final int PRECISION = 131072;
    public static final double PI = Math.PI;
    public static final double TWO_PI = Math.PI * 2;
    public static final double HALF_PI = 1.5707963267948966;
    public static final double PRE_PI_DIV_180 = Math.PI / 180;
    public static final double PRE_180_DIV_PI = 57.29577951308232;
    private static final double RAD_SLICE = 4.7936899621426287E-5;
    private static final double PRECISION_DIV_2PI = 20860.756700940907;
    private static final int PRECISION_S = 131071;
    private static double[] sinTable = new double[131072];
    private static double[] tanTable = new double[131072];
    private static boolean isInitialized = MathUtil.initialize();

    public static boolean initialize() {
        double rad = 0.0;
        for (int i = 0; i < 131072; ++i) {
            rad = (double)i * 4.7936899621426287E-5;
            MathUtil.sinTable[i] = Math.sin(rad);
            MathUtil.tanTable[i] = Math.tan(rad);
        }
        return true;
    }

    private static int radToIndex(double radians) {
        return (int)(radians * 20860.756700940907) & 0x1FFFF;
    }

    public static double sin(double radians) {
        return sinTable[MathUtil.radToIndex(radians)];
    }

    public static double cos(double radians) {
        return sinTable[MathUtil.radToIndex(1.5707963267948966 - radians)];
    }

    public static double tan(double radians) {
        return tanTable[MathUtil.radToIndex(radians)];
    }

    public static double degreesToRadians(double degrees) {
        return degrees * (Math.PI / 180);
    }

    public static double radiansToDegrees(double radians) {
        return radians * 57.29577951308232;
    }

    public static boolean realEqual(double a, double b, double tolerance) {
        return Math.abs(b - a) <= tolerance;
    }

    public static double clamp(double value, double min, double max) {
        return value < min ? min : (value > max ? max : value);
    }

    public static int clamp(int value, int min, int max) {
        return value < min ? min : (value > max ? max : value);
    }

    public static short clamp(short value, short min, short max) {
        return value < min ? min : (value > max ? max : value);
    }

    public static int getClosestPowerOfTwo(int x) {
        --x;
        x |= x >> 1;
        x |= x >> 2;
        x |= x >> 4;
        x |= x >> 8;
        x |= x >> 16;
        return ++x;
    }
}

