/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.materials.textures.utils;

import android.annotation.TargetApi;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.rajawali3d.util.Capabilities;
import org.rajawali3d.util.RajLog;

@TargetApi(value=18)
public class ETC2Util {
    public static final int GL_COMPRESSED_ETC1_RGB8_OES = 36196;
    public static final int GL_COMPRESSED_RGB8_ETC2 = 37492;
    public static final int GL_COMPRESSED_SRGB8_ETC2 = 37493;
    public static final int GL_COMPRESSED_RGBA8_ETC2_EAC = 37496;
    public static final int GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC = 37497;
    public static final int GL_COMPRESSED_R11_EAC = 37488;
    public static final int GL_COMPRESSED_RG11_EAC = 37490;
    public static final int GL_COMPRESSED_SIGNED_R11_EAC = 37489;
    public static final int GL_COMPRESSED_SIGNED_RG11_EAC = 37491;
    public static final int GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2 = 37494;
    public static final int GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2 = 37495;

    public static boolean isETC2Supported() {
        return Capabilities.getGLESMajorVersion() >= 3;
    }

    public static ETC2Texture createTexture(InputStream input) throws IOException {
        int chunkSize;
        int width = 0;
        int height = 0;
        int format = -1;
        byte[] ioBuffer = new byte[4096];
        if (input.read(ioBuffer, 0, 16) != 16) {
            throw new IOException("Unable to read PKM file header.");
        }
        ByteBuffer headerBuffer = ByteBuffer.allocateDirect(16).order(ByteOrder.BIG_ENDIAN);
        headerBuffer.put(ioBuffer, 0, 16).position(0);
        if (!ETC2.isValid(headerBuffer)) {
            throw new IOException("Not a PKM file.");
        }
        width = ETC2.getWidth(headerBuffer);
        height = ETC2.getHeight(headerBuffer);
        format = ETC2.getETC2CompressionType(headerBuffer);
        int encodedSize = ETC2.getEncodedDataSize(width, height);
        ByteBuffer dataBuffer = ByteBuffer.allocateDirect(encodedSize).order(ByteOrder.BIG_ENDIAN);
        for (int i = 0; i < encodedSize; i += chunkSize) {
            chunkSize = Math.min(ioBuffer.length, encodedSize - i);
            if (input.read(ioBuffer, 0, chunkSize) != chunkSize) {
                throw new IOException("Unable to read PKM file data.");
            }
            dataBuffer.put(ioBuffer, 0, chunkSize);
        }
        dataBuffer.position(0);
        return new ETC2Texture(format, width, height, dataBuffer);
    }

    public static final class ETC2 {
        private static final byte[] ETC1Magic = new byte[]{80, 75, 77, 32, 49, 48};
        private static final byte[] ETC2Magic = new byte[]{80, 75, 77, 32, 50, 48};
        private static final int ETC2_PKM_FORMAT_OFFSET = 6;
        private static final int ETC2_PKM_ENCODED_WIDTH_OFFSET = 8;
        private static final int ETC2_PKM_ENCODED_HEIGHT_OFFSET = 10;
        private static final int ETC2_PKM_WIDTH_OFFSET = 12;
        private static final int ETC2_PKM_HEIGHT_OFFSET = 14;
        private static final short ETC1_RGB8_OES = 0;
        private static final short RGB8_ETC2 = 1;
        private static final short RGBA8_ETC2_EAC = 3;
        private static final short RGB8_PUNCHTHROUGH_ALPHA1_ETC2 = 4;
        private static final short R11_EAC = 5;
        private static final short RG11_EAC = 6;
        private static final short SIGNED_R11_EAC = 7;
        private static final short SIGNED_RG11_EAC = 8;

        public static boolean isValid(ByteBuffer header) {
            if (ETC2Magic[0] != header.get(0) && ETC2Magic[1] != header.get(1) && ETC2Magic[2] != header.get(2) && ETC2Magic[3] != header.get(3) && ETC2Magic[4] != header.get(4) && ETC2Magic[5] != header.get(5)) {
                RajLog.e("ETC2 header failed magic sequence check.");
                if (ETC1Magic[0] != header.get(0) && ETC1Magic[1] != header.get(1) && ETC1Magic[2] != header.get(2) && ETC1Magic[3] != header.get(3) && ETC1Magic[4] != header.get(4) && ETC1Magic[5] != header.get(5)) {
                    RajLog.e("ETC1 header failed magic sequence check.");
                    return false;
                }
            }
            short ETC2_FORMAT = header.getShort(6);
            switch (ETC2_FORMAT) {
                case 0: 
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
                default: {
                    RajLog.e("ETC2 header failed format check.");
                    return false;
                }
            }
            int encodedWidth = ETC2.getEncodedWidth(header);
            int encodedHeight = ETC2.getEncodedHeight(header);
            int width = ETC2.getWidth(header);
            int height = ETC2.getHeight(header);
            if (encodedWidth < width || encodedWidth - width > 4) {
                RajLog.e("ETC2 header failed width check. Encoded: " + encodedWidth + " Actual: " + width);
                return false;
            }
            if (encodedHeight < height || encodedHeight - height > 4) {
                RajLog.e("ETC2 header failed height check. Encoded: " + encodedHeight + " Actual: " + height);
                return false;
            }
            return true;
        }

        public static int getETC2CompressionType(ByteBuffer header) {
            switch (header.getShort(6)) {
                case 0: {
                    return 36196;
                }
                case 1: {
                    return 37492;
                }
                case 3: {
                    return 37496;
                }
                case 4: {
                    return 37494;
                }
                case 5: {
                    return 37488;
                }
                case 6: {
                    return 37490;
                }
                case 7: {
                    return 7;
                }
                case 8: {
                    return 8;
                }
            }
            return -1;
        }

        public static int getWidth(ByteBuffer header) {
            return 0xFFFF & header.getShort(12);
        }

        public static int getHeight(ByteBuffer header) {
            return 0xFFFF & header.getShort(14);
        }

        public static int getEncodedWidth(ByteBuffer header) {
            return 0xFFFF & header.getShort(8);
        }

        public static int getEncodedHeight(ByteBuffer header) {
            return 0xFFFF & header.getShort(10);
        }

        public static int getEncodedDataSize(int width, int height) {
            return (width + 3 & 0xFFFFFFFC) * (height + 3 & 0xFFFFFFFC) >> 1;
        }
    }

    public static class ETC2Texture {
        private int mCompressionFormat;
        private int mWidth;
        private int mHeight;
        private ByteBuffer mData;

        public ETC2Texture(int type, int width, int height, ByteBuffer data) {
            this.mCompressionFormat = type;
            this.mWidth = width;
            this.mHeight = height;
            this.mData = data;
        }

        public int getCompressionFormat() {
            return this.mCompressionFormat;
        }

        public int getWidth() {
            return this.mWidth;
        }

        public int getHeight() {
            return this.mHeight;
        }

        public ByteBuffer getData() {
            return this.mData;
        }
    }
}

