/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.materials.textures;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Rect;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.rajawali3d.materials.textures.TextureAtlas;
import org.rajawali3d.util.RajLog;

public class TexturePacker {
    private Context mContext;
    private InputStream[] mInStreams;
    private String[] mFileNames;
    private int mFileCount;
    private int mPadding;
    private int mAtlasWidth;
    private int mAtlasHeight;
    private boolean mResourcesSet = false;
    private BitmapFactory.Options BFO = new BitmapFactory.Options();
    private Bitmap[] mAtlasBitmapPages;

    public TexturePacker(Context context) {
        this.mContext = context;
    }

    public TextureAtlas packTexturesFromAssets(int atlasWidth, int altasHeight, int padding, boolean useCompresison, String subDir) {
        this.assetsToStreams(subDir);
        return this.createAtlas(atlasWidth, altasHeight, padding, useCompresison);
    }

    public TextureAtlas packTexturesFromResources(int atlasWidth, int altasHeight, int padding, boolean useCompresison, int[] resourceIDs) {
        this.resIDsToStreams(resourceIDs);
        return this.createAtlas(atlasWidth, altasHeight, padding, useCompresison);
    }

    private TextureAtlas createAtlas(int atlasWidth, int atlasHeight, int padding, boolean useCompression) {
        this.mPadding = padding;
        this.mAtlasWidth = atlasWidth;
        this.mAtlasHeight = atlasHeight;
        if (!this.mResourcesSet) {
            throw new RuntimeException("ERROR: Resources must be set before packing can begin.");
        }
        TextureAtlas tAtlas = new TextureAtlas(this.mAtlasWidth, this.mAtlasHeight, useCompression);
        Tile[] atlasTiles = new Tile[this.mFileCount];
        this.BFO.inJustDecodeBounds = true;
        for (int i = 0; i < this.mFileCount; ++i) {
            Bitmap texture = null;
            Tile tile = new Tile(null, this.mFileNames[i], 0, 0, 0, 0);
            tile.stream = this.mInStreams[i];
            tile.name = this.mFileNames[i];
            try {
                texture = BitmapFactory.decodeStream((InputStream)tile.stream, null, (BitmapFactory.Options)this.BFO);
            }
            catch (Exception e) {
                RajLog.e("Unable to read " + tile.name + " from stream.");
            }
            tile.width = this.BFO.outWidth;
            tile.height = this.BFO.outHeight;
            atlasTiles[i] = tile;
        }
        RajLog.i("Found " + this.mFileCount + " images to sort and pack.");
        TileComparator tileCompare = new TileComparator();
        Arrays.sort(atlasTiles, tileCompare);
        for (int i = 0; i < this.mFileCount; ++i) {
            Bitmap texture = null;
            Tile tile = atlasTiles[i];
            this.BFO.inSampleSize = 1;
            while (tile.width > this.mAtlasWidth || tile.height > this.mAtlasHeight) {
                RajLog.w("File: '" + tile.name + "' (" + tile.width + "x" + tile.height + ") is larger than the atlas (" + this.mAtlasWidth + "x" + this.mAtlasHeight + ")\nResizing to " + tile.width / 2 + " " + tile.height / 2);
                this.BFO.inSampleSize *= 2;
                try {
                    texture = BitmapFactory.decodeStream((InputStream)tile.stream, null, (BitmapFactory.Options)this.BFO);
                }
                catch (Exception e) {
                    RajLog.e("Unable to read " + this.mFileNames[i] + " from stream.");
                }
                tile.width = this.BFO.outWidth;
                tile.height = this.BFO.outHeight;
            }
            tile.setSampling(this.BFO.inSampleSize);
            atlasTiles[i] = tile;
        }
        tAtlas.setTiles(atlasTiles);
        this.mAtlasBitmapPages = this.packAtlas(atlasTiles, useCompression);
        tAtlas.setPages(this.mAtlasBitmapPages);
        return tAtlas;
    }

    private Bitmap[] packAtlas(Tile[] atlasTiles, boolean useCompression) {
        ArrayList<Bitmap> pageCollection = new ArrayList<Bitmap>();
        Bitmap atlasPage = Bitmap.createBitmap((int)this.mAtlasWidth, (int)this.mAtlasHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas atlasCanvas = new Canvas(atlasPage);
        Node root = new Node(0, 0, this.mAtlasWidth, this.mAtlasHeight);
        int pageNum = 0;
        TexturePacker.checkPOT(atlasPage, "Atlas Page " + pageNum);
        for (int i = 0; i < this.mFileCount; ++i) {
            Bitmap tileImage = null;
            this.BFO.inJustDecodeBounds = false;
            this.BFO.inSampleSize = 1;
            Tile tile = atlasTiles[i];
            Node node = root.Insert(tile);
            if (node != null) {
                this.BFO.inSampleSize = tile.getSampling();
                try {
                    tileImage = BitmapFactory.decodeStream((InputStream)tile.stream, null, (BitmapFactory.Options)this.BFO);
                }
                catch (Exception e) {
                    RajLog.e("Unable to read " + tile.name + " from stream.");
                }
                tile.x = node.rect.left;
                tile.y = node.rect.top;
                TexturePacker.checkPOT(tileImage, tile.name);
                atlasCanvas.drawBitmap(tileImage, (float)tile.x, (float)tile.y, null);
                tileImage = null;
            } else {
                pageCollection.add(atlasPage);
                atlasPage = Bitmap.createBitmap((int)this.mAtlasWidth, (int)this.mAtlasHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                atlasCanvas = new Canvas(atlasPage);
                TexturePacker.checkPOT(atlasPage, "Atlas Page " + pageNum);
                root = new Node(0, 0, this.mAtlasWidth, this.mAtlasHeight);
                ++pageNum;
            }
            tile.setPage(pageNum);
        }
        pageCollection.add(atlasPage);
        Bitmap[] atlasPages = pageCollection.toArray(new Bitmap[pageCollection.size()]);
        return atlasPages;
    }

    private void assetsToStreams(String subDirName) {
        AssetManager am = this.mContext.getAssets();
        try {
            this.mFileNames = am.list(subDirName);
        }
        catch (Exception e) {
            RajLog.e("Unable to read files from assets/" + subDirName + ".");
        }
        this.mFileCount = this.mFileNames.length;
        if (this.mFileCount == 0) {
            RajLog.e("No assets found");
        } else {
            this.mFileCount = this.mFileNames.length;
            InputStream[] streams = new InputStream[this.mFileCount];
            for (int i = 0; i < this.mFileCount; ++i) {
                try {
                    streams[i] = am.open(subDirName + "/" + this.mFileNames[i]);
                    this.mFileNames[i] = this.mFileNames[i].substring(0, this.mFileNames[i].indexOf("."));
                    continue;
                }
                catch (Exception e) {
                    RajLog.e("Unable to open file: assets/" + subDirName + "/" + this.mFileNames[i] + ".");
                }
            }
            this.setStreams(streams);
        }
    }

    private void resIDsToStreams(int[] resourceIDs) {
        this.mFileCount = resourceIDs.length;
        this.mFileNames = new String[this.mFileCount];
        if (this.mFileCount == 0) {
            RajLog.e("No resources found");
        } else {
            InputStream[] is = new InputStream[this.mFileCount];
            for (int i = 0; i < this.mFileCount; ++i) {
                is[i] = this.mContext.getResources().openRawResource(resourceIDs[i]);
                this.mFileNames[i] = this.mContext.getResources().getResourceEntryName(resourceIDs[i]);
            }
            this.setStreams(is);
        }
    }

    private void setStreams(InputStream[] inStreams) {
        this.mInStreams = inStreams;
        this.mResourcesSet = true;
    }

    private static final void checkPOT(Bitmap bitmap, String name) {
        int x = bitmap.getWidth();
        int y = bitmap.getHeight();
        if (x == 0 || (x & x - 1) != 0 || y == 0 || (y & y - 1) != 0) {
            RajLog.w("Loaded texture " + name + " is not a power of two! Texture may fail to render on certain devices.");
        }
    }

    private class TileComparator
    implements Comparator<Tile> {
        private TileComparator() {
        }

        @Override
        public int compare(Tile t1, Tile t2) {
            int a1 = t1.width * t1.height;
            int a2 = t2.width * t1.height;
            if (a1 != a2) {
                return a2 - a1;
            }
            return t1.name.compareTo(t2.name);
        }
    }

    public class Tile {
        public InputStream stream;
        public String name;
        public int x;
        public int y;
        public int width;
        public int height;
        protected int page;
        protected int sampling = 1;

        protected Tile(InputStream inStream, String name, int x, int y, int width, int height) {
            this.stream = inStream;
            this.name = name;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public Bitmap getPage() {
            return TexturePacker.this.mAtlasBitmapPages[this.page];
        }

        protected void setPage(int page) {
            this.page = page;
        }

        protected int getSampling() {
            return this.sampling;
        }

        protected void setSampling(int sampling) {
            this.sampling = sampling;
        }
    }

    private class Node {
        protected Rect rect;
        protected Node[] child;
        protected Tile tile;

        protected Node(int x, int y, int width, int height) {
            this.rect = new Rect(x, y, x + width, y + height);
            this.child = new Node[2];
            this.child[0] = null;
            this.child[1] = null;
            this.tile = null;
        }

        protected boolean isLeaf() {
            return this.child[0] == null && this.child[1] == null;
        }

        protected Node Insert(Tile tile) {
            int dh;
            if (!this.isLeaf()) {
                Node node = this.child[0].Insert(tile);
                if (node != null) {
                    return node;
                }
                return this.child[1].Insert(tile);
            }
            if (this.tile != null) {
                return null;
            }
            if (tile.width > this.rect.width() || tile.height > this.rect.height()) {
                return null;
            }
            if (tile.width == this.rect.width() && tile.height == this.rect.height()) {
                this.tile = tile;
                return this;
            }
            int dw = this.rect.width() - tile.width;
            if (dw > (dh = this.rect.height() - tile.height)) {
                this.child[0] = new Node(this.rect.left, this.rect.top, tile.width, this.rect.height());
                this.child[1] = new Node(TexturePacker.this.mPadding + this.rect.left + tile.width, this.rect.top, this.rect.width() - tile.width - TexturePacker.this.mPadding, this.rect.height());
            } else {
                this.child[0] = new Node(this.rect.left, this.rect.top, this.rect.width(), tile.height);
                this.child[1] = new Node(this.rect.left, TexturePacker.this.mPadding + this.rect.top + tile.height, this.rect.width(), this.rect.height() - tile.height - TexturePacker.this.mPadding);
            }
            return this.child[0].Insert(tile);
        }
    }
}

