/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.materials.textures;

import android.opengl.GLES20;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.rajawali3d.materials.AResourceManager;
import org.rajawali3d.materials.textures.ATexture;
import org.rajawali3d.materials.textures.RenderTargetTexture;
import org.rajawali3d.renderer.Renderer;

public final class TextureManager
extends AResourceManager {
    private static TextureManager instance = null;
    private List<ATexture> mTextureList = Collections.synchronizedList(new CopyOnWriteArrayList());

    private TextureManager() {
        this.mRenderers = Collections.synchronizedList(new CopyOnWriteArrayList());
    }

    public static TextureManager getInstance() {
        if (instance == null) {
            instance = new TextureManager();
        }
        return instance;
    }

    public ATexture addTexture(ATexture texture) {
        this.mRenderer.addTexture(texture);
        return texture;
    }

    public void taskAdd(ATexture texture) {
        this.taskAdd(texture, false);
    }

    private void taskAdd(ATexture texture, boolean isUpdatingAfterContextWasLost) {
        if (!isUpdatingAfterContextWasLost) {
            int count = this.mTextureList.size();
            for (int i = 0; i < count; ++i) {
                if (!this.mTextureList.get(i).getTextureName().equals(texture.getTextureName())) continue;
                if (this.mTextureList.get(i) != texture) {
                    texture.setFrom(this.mTextureList.get(i));
                    continue;
                }
                return;
            }
            texture.setOwnerIdentity(this.mRenderer.getClass().toString());
        }
        try {
            texture.add();
        }
        catch (ATexture.TextureException e) {
            throw new RuntimeException(e);
        }
        if (!isUpdatingAfterContextWasLost) {
            this.mTextureList.add(texture);
        }
    }

    public void replaceTexture(ATexture texture) {
        this.mRenderer.replaceTexture(texture);
    }

    public void taskReplace(ATexture texture) {
        try {
            texture.replace();
        }
        catch (ATexture.TextureException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeTexture(ATexture texture) {
        this.mRenderer.removeTexture(texture);
    }

    public void removeTextures(List<ATexture> textures) {
        int numTextures = textures.size();
        for (int i = 0; i < numTextures; ++i) {
            this.removeTexture(textures.get(i));
        }
    }

    public void taskRemove(ATexture texture) {
        try {
            texture.remove();
        }
        catch (ATexture.TextureException e) {
            throw new RuntimeException(e);
        }
        this.mTextureList.remove(texture);
    }

    public void reload() {
        this.mRenderer.reloadTextures();
    }

    public void taskReload() {
        Iterator<ATexture> iterator = this.mTextureList.iterator();
        while (iterator.hasNext()) {
            ATexture texture = iterator.next();
            if (texture.willRecycle()) {
                iterator.remove();
                continue;
            }
            this.taskAdd(texture, true);
        }
    }

    public void reset() {
        this.mRenderer.resetTextures();
    }

    public void taskReset() {
        try {
            int count = this.mTextureList.size();
            int[] textures = new int[count];
            for (int i = 0; i < count; ++i) {
                ATexture texture = this.mTextureList.get(i);
                if (!texture.getOwnerIdentity().equals(this.mRenderer.getClass().toString()) && !texture.willRecycle()) continue;
                texture.reset();
                textures[i] = texture.getTextureId();
                this.mTextureList.remove(i);
                --i;
                --count;
            }
            if (Renderer.hasGLContext()) {
                GLES20.glDeleteTextures((int)count, (int[])textures, (int)0);
            }
            if (this.mRenderers.size() > 0) {
                this.mRenderer = (Renderer)this.mRenderers.get(this.mRenderers.size() - 1);
                this.reload();
            } else {
                this.mTextureList.clear();
            }
        }
        catch (ATexture.TextureException e) {
            throw new RuntimeException(e);
        }
    }

    public void taskReset(Renderer renderer) {
        if (this.mRenderers.size() == 0) {
            this.taskReset();
        }
    }

    public void taskResizeRenderTarget(RenderTargetTexture renderTargetTexture) {
        renderTargetTexture.resize();
    }

    public int getTextureCount() {
        return this.mTextureList.size();
    }
}

