/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.materials.textures;

import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.media.MediaPlayer;
import android.opengl.GLES20;
import android.view.Surface;
import java.io.IOException;
import org.rajawali3d.materials.textures.ATexture;

public class StreamingTexture
extends ATexture {
    private final int GL_TEXTURE_EXTERNAL_OES = 36197;
    private MediaPlayer mMediaPlayer;
    private Camera mCamera;
    private ISurfaceListener mSurfaceListener;
    private SurfaceTexture mSurfaceTexture;
    private Surface mSurface;
    SurfaceTexture.OnFrameAvailableListener mOnFrameAvailableListener;

    public StreamingTexture(String textureName, MediaPlayer mediaPlayer) {
        super(ATexture.TextureType.VIDEO_TEXTURE, textureName);
        this.mMediaPlayer = mediaPlayer;
        this.setGLTextureType(36197);
    }

    public StreamingTexture(String textureName, Camera camera, SurfaceTexture.OnFrameAvailableListener onFrameAvailableListener) {
        super(ATexture.TextureType.VIDEO_TEXTURE, textureName);
        this.mCamera = camera;
        this.mOnFrameAvailableListener = onFrameAvailableListener;
        this.setGLTextureType(36197);
    }

    public StreamingTexture(String textureName, ISurfaceListener listener) {
        super(ATexture.TextureType.VIDEO_TEXTURE, textureName);
        this.mSurfaceListener = listener;
        this.setGLTextureType(36197);
    }

    public StreamingTexture(StreamingTexture other) {
        super(other);
    }

    @Override
    public StreamingTexture clone() {
        return new StreamingTexture(this);
    }

    @Override
    void add() throws ATexture.TextureException {
        int[] textures = new int[1];
        GLES20.glGenTextures((int)1, (int[])textures, (int)0);
        int textureId = textures[0];
        GLES20.glBindTexture((int)36197, (int)textureId);
        GLES20.glTexParameterf((int)36197, (int)10241, (float)9728.0f);
        GLES20.glTexParameterf((int)36197, (int)10240, (float)9729.0f);
        GLES20.glTexParameterf((int)36197, (int)10242, (float)33071.0f);
        GLES20.glTexParameterf((int)36197, (int)10243, (float)33071.0f);
        this.setTextureId(textureId);
        this.mSurfaceTexture = new SurfaceTexture(textureId);
        if (this.mMediaPlayer != null) {
            this.mSurface = new Surface(this.mSurfaceTexture);
            this.mMediaPlayer.setSurface(this.mSurface);
        } else if (this.mCamera != null) {
            try {
                this.mSurfaceTexture.setOnFrameAvailableListener(this.mOnFrameAvailableListener);
                this.mCamera.setPreviewTexture(this.mSurfaceTexture);
            }
            catch (IOException e) {
                throw new ATexture.TextureException(e);
            }
        } else if (this.mSurfaceListener != null) {
            this.mSurfaceListener.setSurface(new Surface(this.mSurfaceTexture));
        }
    }

    @Override
    void remove() throws ATexture.TextureException {
        GLES20.glDeleteTextures((int)1, (int[])new int[]{this.mTextureId}, (int)0);
        this.mSurfaceTexture.release();
    }

    @Override
    void replace() throws ATexture.TextureException {
    }

    @Override
    void reset() throws ATexture.TextureException {
        this.mSurfaceTexture.release();
    }

    public SurfaceTexture getSurfaceTexture() {
        return this.mSurfaceTexture;
    }

    public void update() {
        if (this.mSurfaceTexture != null) {
            this.mSurfaceTexture.updateTexImage();
        }
    }

    public void updateMediaPlayer(MediaPlayer mediaPlayer) {
        this.mMediaPlayer = mediaPlayer;
        this.mMediaPlayer.setSurface(this.mSurface);
    }

    public static interface ISurfaceListener {
        public void setSurface(Surface var1);
    }
}

