/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.materials.textures;

import android.opengl.GLES20;
import org.rajawali3d.materials.textures.ATexture;
import org.rajawali3d.materials.textures.TextureManager;

public class RenderTargetTexture
extends ATexture {
    private RenderTargetTextureFormat mInternalFormat;
    private RenderTargetTextureFormat mFormat;
    private RenderTargetTextureType mType;

    public RenderTargetTexture(RenderTargetTexture other) {
        super(other);
    }

    public RenderTargetTexture(String textureName) {
        this(textureName, 32, 32);
    }

    public RenderTargetTexture(String textureName, int width, int height) {
        this(textureName, width, height, RenderTargetTextureFormat.RGBA, RenderTargetTextureFormat.RGBA, RenderTargetTextureType.UNSIGNED_BYTE);
    }

    public RenderTargetTexture(String textureName, int width, int height, RenderTargetTextureFormat internalFormat, RenderTargetTextureFormat format, RenderTargetTextureType type) {
        super(ATexture.TextureType.RENDER_TARGET, textureName);
        this.mInternalFormat = internalFormat;
        this.mFormat = format;
        this.mType = type;
        this.mWidth = width;
        this.mHeight = height;
    }

    @Override
    public RenderTargetTexture clone() {
        return new RenderTargetTexture(this);
    }

    @Override
    public void setWidth(int width) {
        super.setWidth(width);
        TextureManager.getInstance().getRenderer().resizeRenderTarget(this);
    }

    @Override
    public void setHeight(int height) {
        super.setHeight(height);
        TextureManager.getInstance().getRenderer().resizeRenderTarget(this);
    }

    public void resize(int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
        TextureManager.getInstance().getRenderer().resizeRenderTarget(this);
    }

    public void setFrom(RenderTargetTexture other) {
        super.setFrom(other);
    }

    @Override
    void add() throws ATexture.TextureException {
        if (this.mWidth == 0 || this.mHeight == 0) {
            throw new ATexture.TextureException("FrameBufferTexture could not be added because the width and/or height weren't specified.");
        }
        int[] textures = new int[1];
        GLES20.glGenTextures((int)1, (int[])textures, (int)0);
        int textureId = textures[0];
        if (textureId > 0) {
            GLES20.glBindTexture((int)3553, (int)textureId);
            if (this.isMipmap()) {
                if (this.mFilterType == ATexture.FilterType.LINEAR) {
                    GLES20.glTexParameterf((int)3553, (int)10241, (float)9987.0f);
                } else {
                    GLES20.glTexParameterf((int)3553, (int)10241, (float)9984.0f);
                }
            } else if (this.mFilterType == ATexture.FilterType.LINEAR) {
                GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
            } else {
                GLES20.glTexParameterf((int)3553, (int)10241, (float)9728.0f);
            }
            if (this.mFilterType == ATexture.FilterType.LINEAR) {
                GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
            } else {
                GLES20.glTexParameterf((int)3553, (int)10240, (float)9728.0f);
            }
            if (this.mWrapType == ATexture.WrapType.REPEAT) {
                GLES20.glTexParameteri((int)3553, (int)10242, (int)10497);
                GLES20.glTexParameteri((int)3553, (int)10243, (int)10497);
            } else {
                GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
                GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
            }
            GLES20.glTexImage2D((int)3553, (int)0, (int)this.mInternalFormat.getFormat(), (int)this.mWidth, (int)this.mHeight, (int)0, (int)this.mFormat.getFormat(), (int)this.mType.getType(), null);
            if (this.isMipmap()) {
                GLES20.glGenerateMipmap((int)3553);
            }
            GLES20.glBindTexture((int)3553, (int)0);
            this.setTextureId(textureId);
        }
    }

    @Override
    void remove() throws ATexture.TextureException {
        GLES20.glDeleteTextures((int)1, (int[])new int[]{this.mTextureId}, (int)0);
    }

    @Override
    void replace() throws ATexture.TextureException {
    }

    void resize() {
        GLES20.glBindTexture((int)3553, (int)this.mTextureId);
        GLES20.glTexImage2D((int)3553, (int)0, (int)this.mInternalFormat.getFormat(), (int)this.mWidth, (int)this.mHeight, (int)0, (int)this.mFormat.getFormat(), (int)this.mType.getType(), null);
        if (this.isMipmap()) {
            GLES20.glGenerateMipmap((int)3553);
        }
        GLES20.glBindTexture((int)3553, (int)0);
    }

    @Override
    void reset() throws ATexture.TextureException {
    }

    public static enum RenderTargetTextureType {
        UNSIGNED_BYTE(5121),
        BYTE(5120),
        UNSIGNED_SHORT(5123),
        SHORT(5122),
        UNSIGNED_INT(5125),
        INT(5124),
        FLOAT(5126);

        private int mType;

        private RenderTargetTextureType(int type) {
            this.mType = type;
        }

        public int getType() {
            return this.mType;
        }
    }

    public static enum RenderTargetTextureFormat {
        RGBA(6408),
        RGB(6407),
        DEPTH(6402),
        DEPTH16(33189);

        private int mFormat;

        private RenderTargetTextureFormat(int format) {
            this.mFormat = format;
        }

        public int getFormat() {
            return this.mFormat;
        }
    }
}

