/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.materials.textures;

import java.nio.ByteBuffer;
import org.rajawali3d.materials.textures.ACompressedTexture;

public class PvrtcTexture
extends ACompressedTexture {
    private static final int GL_COMPRESSED_RGB_PVRTC_4BPPV1_IMG = 35840;
    private static final int GL_COMPRESSED_RGB_PVRTC_2BPPV1_IMG = 35841;
    private static final int GL_COMPRESSED_RGBA_PVRTC_4BPPV1_IMG = 35842;
    private static final int GL_COMPRESSED_RGBA_PVRTC_2BPPV1_IMG = 35843;
    protected PvrtcFormat mPvrtcFormat;

    public PvrtcTexture(PvrtcTexture other) {
        super(other);
        this.setPvrtcFormat(other.getPvrtcFormat());
    }

    public PvrtcTexture(String textureName, ByteBuffer byteBuffer, PvrtcFormat pvrtcFormat) {
        this(textureName, new ByteBuffer[]{byteBuffer}, pvrtcFormat);
    }

    public PvrtcTexture(String textureName, ByteBuffer[] byteBuffers, PvrtcFormat pvrtcFormat) {
        super(textureName, byteBuffers);
        this.setCompressionType(ACompressedTexture.CompressionType.PVRTC);
        this.setPvrtcFormat(pvrtcFormat);
    }

    public void setFrom(PvrtcTexture other) {
        super.setFrom(other);
        this.mPvrtcFormat = other.getPvrtcFormat();
    }

    @Override
    public PvrtcTexture clone() {
        return new PvrtcTexture(this);
    }

    public PvrtcFormat getPvrtcFormat() {
        return this.mPvrtcFormat;
    }

    public void setPvrtcFormat(PvrtcFormat pvrtcFormat) {
        this.mPvrtcFormat = pvrtcFormat;
        switch (pvrtcFormat) {
            case RGB_2BPP: {
                this.mCompressionFormat = 35841;
                break;
            }
            case RGB_4BPP: {
                this.mCompressionFormat = 35840;
                break;
            }
            case RGBA_2BPP: {
                this.mCompressionFormat = 35843;
                break;
            }
            default: {
                this.mCompressionFormat = 35842;
            }
        }
    }

    public static enum PvrtcFormat {
        RGB_2BPP,
        RGB_4BPP,
        RGBA_2BPP,
        RGBA_4BPP;

    }
}

