/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.materials.textures;

import java.nio.ByteBuffer;
import org.rajawali3d.materials.textures.ACompressedTexture;

public class PalettedTexture
extends ACompressedTexture {
    private static final int GL_PALETTE4_RGB8_OES = 35728;
    private static final int GL_PALETTE4_RGBA8_OES = 35729;
    private static final int GL_PALETTE4_R5_G6_B5_OES = 35730;
    private static final int GL_PALETTE4_RGBA4_OES = 35731;
    private static final int GL_PALETTE4_RGB5_A1_OES = 35732;
    private static final int GL_PALETTE8_RGB8_OES = 35733;
    private static final int GL_PALETTE8_RGBA8_OES = 35734;
    private static final int GL_PALETTE8_R5_G6_B5_OES = 35735;
    private static final int GL_PALETTE8_RGBA4_OES = 35736;
    private static final int GL_PALETTE8_RGB5_A1_OES = 35737;
    private PaletteFormat mPaletteFormat;

    public PalettedTexture(PalettedTexture other) {
        super(other);
        this.setPaletteFormat(other.getPaletteFormat());
    }

    public PalettedTexture(String textureName, ByteBuffer byteBuffer, PaletteFormat paletteFormat) {
        this(textureName, new ByteBuffer[]{byteBuffer}, paletteFormat);
    }

    public PalettedTexture(String textureName, ByteBuffer[] byteBuffers, PaletteFormat paletteFormat) {
        super(textureName, byteBuffers);
        this.setPaletteFormat(paletteFormat);
        this.setCompressionType(ACompressedTexture.CompressionType.PALETTED);
    }

    public void setFrom(PalettedTexture other) {
        super.setFrom(other);
        this.mPaletteFormat = other.getPaletteFormat();
    }

    public PaletteFormat getPaletteFormat() {
        return this.mPaletteFormat;
    }

    public void setPaletteFormat(PaletteFormat paletteFormat) {
        this.mPaletteFormat = paletteFormat;
        this.checkPaletteFormat();
    }

    @Override
    public PalettedTexture clone() {
        return new PalettedTexture(this);
    }

    private void checkPaletteFormat() {
        switch (this.mPaletteFormat) {
            case PALETTE4_RGB8: {
                this.mCompressionFormat = 35728;
                break;
            }
            case PALETTE4_RGBA8: {
                this.mCompressionFormat = 35729;
                break;
            }
            case PALETTE4_R5_G6_B5: {
                this.mCompressionFormat = 35730;
                break;
            }
            case PALETTE4_RGBA4: {
                this.mCompressionFormat = 35731;
                break;
            }
            case PALETTE4_RGB5_A1: {
                this.mCompressionFormat = 35732;
                break;
            }
            case PALETTE8_RGB8: {
                this.mCompressionFormat = 35733;
                break;
            }
            default: {
                this.mCompressionFormat = 35734;
                break;
            }
            case PALETTE8_R5_G6_B5: {
                this.mCompressionFormat = 35735;
                break;
            }
            case PALETTE8_RGBA4: {
                this.mCompressionFormat = 35736;
                break;
            }
            case PALETTE8_RGB5_A1: {
                this.mCompressionFormat = 35737;
            }
        }
    }

    public static enum PaletteFormat {
        PALETTE4_RGB8,
        PALETTE4_RGBA8,
        PALETTE4_R5_G6_B5,
        PALETTE4_RGBA4,
        PALETTE4_RGB5_A1,
        PALETTE8_RGB8,
        PALETTE8_RGBA8,
        PALETTE8_R5_G6_B5,
        PALETTE8_RGBA4,
        PALETTE8_RGB5_A1;

    }
}

