/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.materials.textures;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.opengl.ETC1;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.rajawali3d.materials.textures.ACompressedTexture;
import org.rajawali3d.materials.textures.ATexture;
import org.rajawali3d.materials.textures.Etc1Texture;
import org.rajawali3d.materials.textures.TextureManager;
import org.rajawali3d.materials.textures.utils.ETC2Util;
import org.rajawali3d.util.RajLog;

@TargetApi(value=18)
public class Etc2Texture
extends ACompressedTexture {
    protected int mResourceId;
    protected Bitmap mBitmap;

    public Etc2Texture(String textureName) {
        super(textureName);
        this.mCompressionType = ACompressedTexture.CompressionType.ETC2;
    }

    public Etc2Texture(int resourceId) {
        this(TextureManager.getInstance().getContext().getResources().getResourceName(resourceId));
        this.setResourceId(resourceId);
    }

    public Etc2Texture(String textureName, int resourceId, Bitmap fallbackTexture) {
        this(textureName);
        Context context = TextureManager.getInstance().getContext();
        this.setInputStream(context.getResources().openRawResource(resourceId), fallbackTexture);
    }

    public Etc2Texture(String textureName, int[] resourceIds) {
        this(textureName);
        this.setResourceIds(resourceIds);
    }

    public Etc2Texture(String textureName, ByteBuffer byteBuffer) {
        this(textureName);
        this.setByteBuffer(byteBuffer);
    }

    public Etc2Texture(String textureName, ByteBuffer[] byteBuffers) {
        this(textureName);
        this.setByteBuffers(byteBuffers);
    }

    public Etc2Texture(String textureName, InputStream compressedTexture, Bitmap fallbackTexture) {
        this(textureName);
        this.setInputStream(compressedTexture, fallbackTexture);
    }

    public Etc2Texture(Etc1Texture other) {
        this.setFrom(other);
    }

    @Override
    public ATexture clone() {
        return null;
    }

    @Override
    void add() throws ATexture.TextureException {
        super.add();
        if (this.mShouldRecycle && this.mBitmap != null) {
            this.mBitmap.recycle();
            this.mBitmap = null;
        }
    }

    @Override
    void reset() throws ATexture.TextureException {
        super.reset();
        if (this.mBitmap != null) {
            this.mBitmap.recycle();
            this.mBitmap = null;
        }
    }

    public void setResourceId(int resourceId) {
        this.mResourceId = resourceId;
        Resources resources = TextureManager.getInstance().getContext().getResources();
        try {
            ETC2Util.ETC2Texture texture = ETC2Util.createTexture(resources.openRawResource(resourceId));
            this.mByteBuffers = new ByteBuffer[]{texture.getData()};
            this.setWidth(texture.getWidth());
            this.setHeight(texture.getHeight());
            this.setCompressionFormat(texture.getCompressionFormat());
        }
        catch (IOException e) {
            RajLog.e(e.getMessage());
            e.printStackTrace();
        }
    }

    public int getResourceId() {
        return this.mResourceId;
    }

    public void setResourceIds(int[] resourceIds) {
        ByteBuffer[] mipmapChain = new ByteBuffer[resourceIds.length];
        Resources resources = TextureManager.getInstance().getContext().getResources();
        int mip_0_width = 1;
        int mip_0_height = 1;
        try {
            int length = resourceIds.length;
            for (int i = 0; i < length; ++i) {
                ETC2Util.ETC2Texture texture = ETC2Util.createTexture(resources.openRawResource(resourceIds[i]));
                if (i == 0) {
                    this.setCompressionFormat(texture.getCompressionFormat());
                } else if (this.getCompressionFormat() != texture.getCompressionFormat()) {
                    throw new IllegalArgumentException("The ETC2 compression formats of all textures in the chain much match");
                }
                mipmapChain[i] = texture.getData();
                if (i != 0) continue;
                mip_0_width = texture.getWidth();
                mip_0_height = texture.getHeight();
            }
            this.setWidth(mip_0_width);
            this.setHeight(mip_0_height);
        }
        catch (IOException e) {
            RajLog.e(e.getMessage());
            e.printStackTrace();
        }
        this.mByteBuffers = mipmapChain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInputStream(InputStream compressedTexture, Bitmap fallbackTexture) {
        ETC2Util.ETC2Texture texture = null;
        try {
            texture = ETC2Util.createTexture(compressedTexture);
        }
        catch (IOException e) {
            RajLog.e("addEtc2Texture:" + e.getMessage());
        }
        finally {
            if (texture == null) {
                this.setBitmap(fallbackTexture);
                if (RajLog.isDebugEnabled()) {
                    RajLog.d("Falling back to ETC1 texture from fallback texture.");
                }
            } else {
                this.setCompressionFormat(texture.getCompressionFormat());
                this.setByteBuffer(texture.getData());
                this.setWidth(texture.getWidth());
                this.setHeight(texture.getHeight());
                if (RajLog.isDebugEnabled()) {
                    RajLog.d("ETC2 texture load successful");
                }
            }
        }
    }

    private void setBitmap(Bitmap bitmap) {
        this.mBitmap = bitmap;
        int imageSize = bitmap.getRowBytes() * bitmap.getHeight();
        ByteBuffer uncompressedBuffer = ByteBuffer.allocateDirect(imageSize);
        bitmap.copyPixelsToBuffer((Buffer)uncompressedBuffer);
        uncompressedBuffer.position(0);
        ByteBuffer compressedBuffer = ByteBuffer.allocateDirect(ETC1.getEncodedDataSize((int)bitmap.getWidth(), (int)bitmap.getHeight())).order(ByteOrder.nativeOrder());
        ETC1.encodeImage((Buffer)uncompressedBuffer, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (int)2, (int)(2 * bitmap.getWidth()), (Buffer)compressedBuffer);
        this.setCompressionFormat(36196);
        this.mByteBuffers = new ByteBuffer[]{compressedBuffer};
        this.setWidth(bitmap.getWidth());
        this.setHeight(bitmap.getHeight());
    }
}

