/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.materials.textures;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.opengl.ETC1;
import android.opengl.ETC1Util;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.rajawali3d.materials.textures.ACompressedTexture;
import org.rajawali3d.materials.textures.ATexture;
import org.rajawali3d.materials.textures.TextureManager;
import org.rajawali3d.util.RajLog;

public class Etc1Texture
extends ACompressedTexture {
    protected int mResourceId = -1;
    protected int[] mResourceIds;
    protected Bitmap mBitmap;

    public Etc1Texture(String textureName) {
        super(textureName);
        this.mCompressionType = ACompressedTexture.CompressionType.ETC1;
        this.mCompressionFormat = 36196;
    }

    public Etc1Texture(int resourceId) {
        this(TextureManager.getInstance().getContext().getResources().getResourceName(resourceId));
        this.setResourceId(resourceId);
    }

    public Etc1Texture(String textureName, int resourceId, Bitmap fallbackTexture) {
        this(textureName);
        Context context = TextureManager.getInstance().getContext();
        this.setInputStream(context.getResources().openRawResource(resourceId), fallbackTexture);
    }

    public Etc1Texture(String textureName, int[] resourceIds) {
        this(textureName);
        this.setResourceIds(resourceIds);
    }

    public Etc1Texture(String textureName, ByteBuffer byteBuffer) {
        this(textureName);
        this.setByteBuffer(byteBuffer);
    }

    public Etc1Texture(String textureName, ByteBuffer[] byteBuffers) {
        this(textureName);
        this.setByteBuffers(byteBuffers);
    }

    public Etc1Texture(String textureName, InputStream compressedTexture, Bitmap fallbackTexture) {
        this(textureName);
        this.setInputStream(compressedTexture, fallbackTexture);
    }

    public Etc1Texture(Etc1Texture other) {
        this.setFrom(other);
    }

    @Override
    public Etc1Texture clone() {
        return new Etc1Texture(this);
    }

    @Override
    void add() throws ATexture.TextureException {
        if (this.mResourceId != -1) {
            Resources resources = TextureManager.getInstance().getContext().getResources();
            try {
                ETC1Util.ETC1Texture texture = ETC1Util.createTexture((InputStream)resources.openRawResource(this.mResourceId));
                this.mByteBuffers = new ByteBuffer[]{texture.getData()};
                this.setWidth(texture.getWidth());
                this.setHeight(texture.getHeight());
                this.setCompressionFormat(36196);
            }
            catch (IOException e) {
                RajLog.e(e.getMessage());
                e.printStackTrace();
            }
        } else if (this.mResourceIds != null) {
            ByteBuffer[] mipmapChain = new ByteBuffer[this.mResourceIds.length];
            Resources resources = TextureManager.getInstance().getContext().getResources();
            int mip_0_width = 1;
            int mip_0_height = 1;
            try {
                int length = this.mResourceIds.length;
                for (int i = 0; i < length; ++i) {
                    ETC1Util.ETC1Texture texture = ETC1Util.createTexture((InputStream)resources.openRawResource(this.mResourceIds[i]));
                    mipmapChain[i] = texture.getData();
                    if (i != 0) continue;
                    mip_0_width = texture.getWidth();
                    mip_0_height = texture.getHeight();
                }
                this.setWidth(mip_0_width);
                this.setHeight(mip_0_height);
                this.setCompressionFormat(36196);
            }
            catch (IOException e) {
                RajLog.e(e.getMessage());
                e.printStackTrace();
            }
            this.mByteBuffers = mipmapChain;
        }
        super.add();
        if (this.mShouldRecycle) {
            if (this.mBitmap != null) {
                this.mBitmap.recycle();
                this.mBitmap = null;
            }
            if (this.mByteBuffers != null) {
                int count = this.mByteBuffers.length;
                for (int i = 0; i < count; ++i) {
                    this.mByteBuffers[i].clear();
                    this.mByteBuffers[i] = null;
                }
                this.mByteBuffers = null;
            }
        }
    }

    @Override
    void reset() throws ATexture.TextureException {
        super.reset();
        if (this.mBitmap != null) {
            this.mBitmap.recycle();
            this.mBitmap = null;
        }
        if (this.mByteBuffers != null) {
            int count = this.mByteBuffers.length;
            for (int i = 0; i < count; ++i) {
                this.mByteBuffers[i].clear();
                this.mByteBuffers[i] = null;
            }
            this.mByteBuffers = null;
        }
    }

    public void setResourceId(int resourceId) {
        this.mResourceId = resourceId;
    }

    public int getResourceId() {
        return this.mResourceId;
    }

    public void setResourceIds(int[] resourceIds) {
        this.mResourceIds = resourceIds;
    }

    public void setBitmap(Bitmap bitmap) {
        this.mBitmap = bitmap;
        int imageSize = bitmap.getRowBytes() * bitmap.getHeight();
        ByteBuffer uncompressedBuffer = ByteBuffer.allocateDirect(imageSize);
        bitmap.copyPixelsToBuffer((Buffer)uncompressedBuffer);
        uncompressedBuffer.position(0);
        ByteBuffer compressedBuffer = ByteBuffer.allocateDirect(ETC1.getEncodedDataSize((int)bitmap.getWidth(), (int)bitmap.getHeight())).order(ByteOrder.nativeOrder());
        ETC1.encodeImage((Buffer)uncompressedBuffer, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (int)2, (int)(2 * bitmap.getWidth()), (Buffer)compressedBuffer);
        this.mByteBuffers = new ByteBuffer[]{compressedBuffer};
        this.setWidth(bitmap.getWidth());
        this.setHeight(bitmap.getHeight());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInputStream(InputStream compressedTexture, Bitmap fallbackTexture) {
        ETC1Util.ETC1Texture texture = null;
        try {
            texture = ETC1Util.createTexture((InputStream)compressedTexture);
        }
        catch (IOException e) {
            RajLog.e("addEtc1Texture: " + e.getMessage());
        }
        finally {
            if (texture == null) {
                this.setBitmap(fallbackTexture);
                if (RajLog.isDebugEnabled()) {
                    RajLog.d("Falling back to uncompressed texture");
                }
            } else {
                this.setByteBuffer(texture.getData());
                this.setWidth(texture.getWidth());
                this.setHeight(texture.getHeight());
                if (RajLog.isDebugEnabled()) {
                    RajLog.d("ETC1 texture load successful");
                }
            }
        }
    }
}

