/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.materials.textures;

import java.nio.ByteBuffer;
import org.rajawali3d.materials.textures.ACompressedTexture;

public class Dxt1Texture
extends ACompressedTexture {
    private static final int GL_COMPRESSED_RGB_S3TC_DXT1_EXT = 33776;
    private static final int GL_COMPRESSED_RGBA_S3TC_DXT1_EXT = 33777;
    protected Dxt1Format mDxt1Format;

    public Dxt1Texture(Dxt1Texture other) {
        super(other);
        this.setDxt1Format(other.getDxt1Format());
    }

    public Dxt1Texture(String textureName, ByteBuffer byteBuffer, Dxt1Format dxt1Format) {
        this(textureName, new ByteBuffer[]{byteBuffer}, dxt1Format);
    }

    public Dxt1Texture(String textureName, ByteBuffer[] byteBuffers, Dxt1Format dxt1Format) {
        super(textureName, byteBuffers);
        this.setCompressionType(ACompressedTexture.CompressionType.DXT1);
        this.setDxt1Format(dxt1Format);
    }

    public void setFrom(Dxt1Texture other) {
        super.setFrom(other);
        this.mDxt1Format = other.getDxt1Format();
    }

    @Override
    public Dxt1Texture clone() {
        return new Dxt1Texture(this);
    }

    public Dxt1Format getDxt1Format() {
        return this.mDxt1Format;
    }

    public void setDxt1Format(Dxt1Format dxt1Format) {
        this.mDxt1Format = dxt1Format;
        switch (dxt1Format) {
            case RGB: {
                this.mCompressionFormat = 33776;
                break;
            }
            default: {
                this.mCompressionFormat = 33777;
            }
        }
    }

    public static enum Dxt1Format {
        RGB,
        RGBA;

    }
}

