/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.materials.textures;

import android.graphics.Bitmap;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.rajawali3d.materials.textures.ACompressedTexture;
import org.rajawali3d.materials.textures.AMultiTexture;
import org.rajawali3d.materials.textures.ATexture;

public class CubeMapTexture
extends AMultiTexture {
    public final int[] CUBE_FACES = new int[]{34069, 34070, 34071, 34072, 34073, 34074};
    private boolean mIsSkyTexture;
    private boolean mIsEnvironmentTexture;
    private boolean mHasCompressedTextures;

    public CubeMapTexture(CubeMapTexture other) {
        super(other);
    }

    public CubeMapTexture(String textureName) {
        super(ATexture.TextureType.CUBE_MAP, textureName);
        this.setWrapType(ATexture.WrapType.CLAMP);
        this.setGLTextureType(34067);
    }

    public CubeMapTexture(String textureName, int[] resourceIds) {
        super(ATexture.TextureType.CUBE_MAP, textureName, resourceIds);
        this.setWrapType(ATexture.WrapType.CLAMP);
        this.setGLTextureType(34067);
    }

    public CubeMapTexture(String textureName, Bitmap[] bitmaps) {
        super(ATexture.TextureType.CUBE_MAP, textureName, bitmaps);
        this.setWrapType(ATexture.WrapType.CLAMP);
        this.setGLTextureType(34067);
    }

    public CubeMapTexture(String textureName, ByteBuffer[] byteBuffers) {
        super(ATexture.TextureType.CUBE_MAP, textureName, byteBuffers);
        this.setWrapType(ATexture.WrapType.CLAMP);
        this.setGLTextureType(34067);
    }

    public CubeMapTexture(String textureName, ACompressedTexture[] compressedTextures) {
        super(ATexture.TextureType.CUBE_MAP, textureName, compressedTextures);
        this.mHasCompressedTextures = true;
        this.setWrapType(ATexture.WrapType.CLAMP);
        this.setGLTextureType(34067);
    }

    @Override
    public CubeMapTexture clone() {
        return new CubeMapTexture(this);
    }

    private void checkBitmapConfiguration() throws ATexture.TextureException {
        if (!(this.mBitmaps != null && this.mBitmaps.length != 0 || this.mByteBuffers != null && this.mByteBuffers.length != 0 || this.mHasCompressedTextures)) {
            throw new ATexture.TextureException("Texture could not be added because no Bitmaps or ByteBuffers set.");
        }
        if (this.mBitmaps != null && this.mBitmaps.length != 6) {
            throw new ATexture.TextureException("CubeMapTexture could not be added because it needs six textures instead of " + this.mBitmaps.length);
        }
        if (this.mBitmaps != null) {
            this.setBitmapConfig(this.mBitmaps[0].getConfig());
            this.setBitmapFormat(this.mBitmapConfig == Bitmap.Config.ARGB_8888 ? 6408 : 6407);
            this.setWidth(this.mBitmaps[0].getWidth());
            this.setHeight(this.mBitmaps[0].getHeight());
        }
    }

    private void setTextureData() {
        if (this.isMipmap()) {
            if (this.mFilterType == ATexture.FilterType.LINEAR) {
                GLES20.glTexParameterf((int)34067, (int)10241, (float)9987.0f);
            } else {
                GLES20.glTexParameterf((int)34067, (int)10241, (float)9984.0f);
            }
        } else if (this.mFilterType == ATexture.FilterType.LINEAR) {
            GLES20.glTexParameterf((int)34067, (int)10241, (float)9729.0f);
        } else {
            GLES20.glTexParameterf((int)34067, (int)10241, (float)9728.0f);
        }
        if (this.mFilterType == ATexture.FilterType.LINEAR) {
            GLES20.glTexParameterf((int)34067, (int)10240, (float)9729.0f);
        } else {
            GLES20.glTexParameterf((int)34067, (int)10240, (float)9728.0f);
        }
        if (this.mWrapType == ATexture.WrapType.REPEAT) {
            GLES20.glTexParameteri((int)34067, (int)10242, (int)10497);
            GLES20.glTexParameteri((int)34067, (int)10243, (int)10497);
        } else {
            GLES20.glTexParameteri((int)34067, (int)10242, (int)33071);
            GLES20.glTexParameteri((int)34067, (int)10243, (int)33071);
        }
        for (int i = 0; i < 6; ++i) {
            GLES20.glHint((int)33170, (int)4354);
            if (this.mBitmaps != null) {
                GLUtils.texImage2D((int)this.CUBE_FACES[i], (int)0, (Bitmap)this.mBitmaps[i], (int)0);
                continue;
            }
            if (this.mHasCompressedTextures) {
                ACompressedTexture tex = this.mCompressedTextures[i];
                int w = tex.getWidth();
                int h = tex.getHeight();
                for (int j = 0; j < tex.getByteBuffers().length; ++j) {
                    GLES20.glCompressedTexImage2D((int)this.CUBE_FACES[i], (int)j, (int)tex.getCompressionFormat(), (int)w, (int)h, (int)0, (int)tex.getByteBuffers()[j].capacity(), (Buffer)tex.getByteBuffers()[j]);
                    w = w > 1 ? w / 2 : 1;
                    h = h > 1 ? h / 2 : 1;
                }
                continue;
            }
            GLES20.glTexImage2D((int)34067, (int)0, (int)this.mBitmapFormat, (int)this.mWidth, (int)this.mHeight, (int)0, (int)this.mBitmapFormat, (int)5121, (Buffer)this.mByteBuffers[i]);
        }
        if (this.isMipmap()) {
            GLES20.glGenerateMipmap((int)34067);
        }
        if (this.mShouldRecycle) {
            if (this.mBitmaps != null) {
                for (Bitmap bitmap : this.mBitmaps) {
                    bitmap.recycle();
                    bitmap = null;
                }
                this.mBitmaps = null;
            }
            this.mByteBuffers = null;
        }
        GLES20.glBindTexture((int)34067, (int)0);
    }

    @Override
    void add() throws ATexture.TextureException {
        if (this.mHasCompressedTextures) {
            for (int i = 0; i < this.mCompressedTextures.length; ++i) {
                this.mCompressedTextures[i].add();
            }
        }
        this.checkBitmapConfiguration();
        int[] genTextureNames = new int[1];
        GLES20.glGenTextures((int)1, (int[])genTextureNames, (int)0);
        int textureId = genTextureNames[0];
        if (textureId <= 0) {
            throw new ATexture.TextureException("Couldn't generate a texture name.");
        }
        GLES20.glBindTexture((int)34067, (int)textureId);
        this.setTextureData();
        this.setTextureId(textureId);
    }

    @Override
    void remove() throws ATexture.TextureException {
        if (this.mHasCompressedTextures) {
            for (int i = 0; i < this.mCompressedTextures.length; ++i) {
                this.mCompressedTextures[i].remove();
            }
        }
        GLES20.glDeleteTextures((int)1, (int[])new int[]{this.mTextureId}, (int)0);
    }

    @Override
    void replace() throws ATexture.TextureException {
        this.checkBitmapConfiguration();
        if (this.mTextureId > 0) {
            GLES20.glBindTexture((int)34067, (int)this.mTextureId);
            if (this.mHasCompressedTextures) {
                for (int i = 0; i < 6; ++i) {
                    ACompressedTexture tex = this.mCompressedTextures[i];
                    tex.add();
                    int w = tex.getWidth();
                    int h = tex.getHeight();
                    for (int j = 0; j < tex.getByteBuffers().length; ++j) {
                        GLES20.glCompressedTexSubImage2D((int)this.CUBE_FACES[i], (int)j, (int)0, (int)0, (int)w, (int)h, (int)tex.getCompressionFormat(), (int)tex.getByteBuffers()[j].capacity(), (Buffer)tex.getByteBuffers()[j]);
                        w = w > 1 ? w / 2 : 1;
                        h = h > 1 ? h / 2 : 1;
                    }
                }
                GLES20.glBindTexture((int)34067, (int)0);
            } else {
                this.setTextureData();
            }
        } else {
            throw new ATexture.TextureException("Couldn't generate a texture name.");
        }
    }

    public void isSkyTexture(boolean value) {
        this.mIsSkyTexture = value;
        this.mIsEnvironmentTexture = !value;
    }

    public boolean isSkyTexture() {
        return this.mIsSkyTexture;
    }

    public void isEnvironmentTexture(boolean value) {
        this.mIsEnvironmentTexture = value;
        this.mIsSkyTexture = !this.mIsEnvironmentTexture;
    }

    public boolean isEnvironmentTexture() {
        return this.mIsEnvironmentTexture;
    }
}

