/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.materials.textures;

import java.nio.ByteBuffer;
import org.rajawali3d.materials.textures.ACompressedTexture;

public class AtcTexture
extends ACompressedTexture {
    protected AtcFormat mAtcFormat;

    public AtcTexture(AtcTexture other) {
        super(other);
        this.setAtcFormat(other.getAtcFormat());
    }

    public AtcTexture(String textureName, ByteBuffer byteBuffer, AtcFormat atcFormat) {
        this(textureName, new ByteBuffer[]{byteBuffer}, atcFormat);
    }

    public AtcTexture(String textureName, ByteBuffer[] byteBuffers, AtcFormat atcFormat) {
        super(textureName, byteBuffers);
        this.setCompressionType(ACompressedTexture.CompressionType.ATC);
        this.setAtcFormat(atcFormat);
    }

    public void setFrom(AtcTexture other) {
        super.setFrom(other);
        this.mAtcFormat = other.getAtcFormat();
    }

    @Override
    public AtcTexture clone() {
        return new AtcTexture(this);
    }

    public AtcFormat getAtcFormat() {
        return this.mAtcFormat;
    }

    public void setAtcFormat(AtcFormat atcFormat) {
        this.mAtcFormat = atcFormat;
        switch (atcFormat) {
            case RGB: {
                this.mCompressionFormat = 35986;
                break;
            }
            default: {
                this.mCompressionFormat = 35987;
                break;
            }
            case RGBA_INTERPOLATED: {
                this.mCompressionFormat = 34798;
            }
        }
    }

    public static enum AtcFormat {
        RGB,
        RGBA_EXPLICIT,
        RGBA_INTERPOLATED;

    }
}

