/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.materials.textures;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Movie;
import android.os.SystemClock;
import java.io.InputStream;
import org.rajawali3d.materials.textures.ASingleTexture;
import org.rajawali3d.materials.textures.ATexture;
import org.rajawali3d.materials.textures.TextureManager;

public class AnimatedGIFTexture
extends ASingleTexture {
    private Canvas mCanvas;
    private Movie mMovie;
    private Bitmap mGIFBitmap;
    private int mResourceId;
    private int mWidth;
    private int mHeight;
    private int mTextureSize;
    private long mStartTime;
    private boolean mLoadNewGIF;

    public AnimatedGIFTexture(String name, int resourceId) {
        this(name, resourceId, 512);
    }

    public AnimatedGIFTexture(String name, int resourceId, int textureSize) {
        super(ATexture.TextureType.DIFFUSE, name);
        this.mTextureSize = textureSize;
        this.mResourceId = resourceId;
        this.loadGIF();
    }

    public AnimatedGIFTexture(AnimatedGIFTexture other) {
        super(other);
        this.setFrom(other);
    }

    @Override
    public AnimatedGIFTexture clone() {
        return new AnimatedGIFTexture(this);
    }

    private void loadGIF() {
        Context context = TextureManager.getInstance().getContext();
        this.mMovie = Movie.decodeStream((InputStream)context.getResources().openRawResource(this.mResourceId));
        this.mWidth = this.mMovie.width();
        this.mHeight = this.mMovie.height();
        this.mGIFBitmap = Bitmap.createBitmap((int)this.mWidth, (int)this.mHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.mCanvas = new Canvas(this.mGIFBitmap);
        this.mMovie.draw(this.mCanvas, 0.0f, 0.0f);
        this.mBitmap = Bitmap.createScaledBitmap((Bitmap)this.mGIFBitmap, (int)this.mTextureSize, (int)this.mTextureSize, (boolean)false);
    }

    public void setFrom(AnimatedGIFTexture other) {
        super.setFrom(other);
        this.mBitmap = other.getBitmap();
        this.mCanvas = other.getCanvas();
        this.mMovie = other.getMovie();
        this.mWidth = other.getWidth();
        this.mHeight = other.getHeight();
        this.mTextureSize = other.getTextureSize();
    }

    public void rewind() {
        this.mStartTime = SystemClock.uptimeMillis();
    }

    @Override
    void replace() throws ATexture.TextureException {
        if (this.mLoadNewGIF) {
            this.loadGIF();
            this.mLoadNewGIF = false;
        }
        super.replace();
    }

    public void update() throws ATexture.TextureException {
        if (this.mMovie == null || this.mMovie.duration() == 0) {
            return;
        }
        long now = SystemClock.uptimeMillis();
        int relTime = (int)((now - this.mStartTime) % (long)this.mMovie.duration());
        this.mMovie.setTime(relTime);
        this.mGIFBitmap.eraseColor(0);
        this.mMovie.draw(this.mCanvas, 0.0f, 0.0f);
        this.mBitmap = Bitmap.createScaledBitmap((Bitmap)this.mGIFBitmap, (int)this.mTextureSize, (int)this.mTextureSize, (boolean)false);
        TextureManager.getInstance().replaceTexture(this);
        this.replace();
    }

    @Override
    public void setResourceId(int resourceId) {
        if (this.mResourceId == resourceId) {
            return;
        }
        this.mResourceId = resourceId;
        this.mLoadNewGIF = true;
    }

    @Override
    public void reset() throws ATexture.TextureException {
        super.reset();
        if (this.mGIFBitmap != null) {
            this.mGIFBitmap.recycle();
            this.mGIFBitmap = null;
        }
        this.mCanvas = null;
        this.mMovie = null;
    }

    @Override
    void remove() throws ATexture.TextureException {
        if (this.mGIFBitmap != null) {
            this.mGIFBitmap.recycle();
            this.mGIFBitmap = null;
        }
        this.mCanvas = null;
        this.mMovie = null;
        super.remove();
    }

    @Override
    public int getResourceId() {
        return this.mResourceId;
    }

    public Canvas getCanvas() {
        return this.mCanvas;
    }

    public Movie getMovie() {
        return this.mMovie;
    }

    @Override
    public int getWidth() {
        return this.mWidth;
    }

    @Override
    public int getHeight() {
        return this.mHeight;
    }

    public int getTextureSize() {
        return this.mTextureSize;
    }
}

