/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.materials.textures;

import android.graphics.Bitmap;
import android.support.annotation.NonNull;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.rajawali3d.materials.Material;
import org.rajawali3d.materials.textures.ACompressedTexture;

public abstract class ATexture {
    protected int mTextureId = -1;
    protected int mWidth;
    protected int mHeight;
    protected int mBitmapFormat;
    protected boolean mMipmap;
    protected boolean mShouldRecycle;
    @NonNull
    protected String mTextureName;
    protected TextureType mTextureType;
    protected WrapType mWrapType;
    protected FilterType mFilterType;
    protected Bitmap.Config mBitmapConfig;
    protected List<Material> mMaterialsUsingTexture;
    protected ACompressedTexture mCompressedTexture;
    protected int mGLTextureType = 3553;
    protected String mOwnerIdentity;
    protected float mInfluence = 1.0f;
    protected float[] mRepeat = new float[]{1.0f, 1.0f};
    protected boolean mEnableOffset;
    protected float[] mOffset = new float[]{0.0f, 0.0f};

    public ATexture(TextureType textureType, @NonNull String textureName) {
        this();
        this.mTextureType = textureType;
        this.mTextureName = textureName;
        this.mMipmap = true;
        this.mShouldRecycle = false;
        this.mWrapType = WrapType.REPEAT;
        this.mFilterType = FilterType.LINEAR;
    }

    public ATexture(TextureType textureType, @NonNull String textureName, ACompressedTexture compressedTexture) {
        this(textureType, textureName);
        this.setCompressedTexture(compressedTexture);
    }

    protected ATexture() {
        this.mMaterialsUsingTexture = Collections.synchronizedList(new CopyOnWriteArrayList());
    }

    public ATexture(ATexture other) {
        this.setFrom(other);
    }

    public abstract ATexture clone();

    public void setFrom(ATexture other) {
        this.mTextureId = other.getTextureId();
        this.mWidth = other.getWidth();
        this.mHeight = other.getHeight();
        this.mBitmapFormat = other.getBitmapFormat();
        this.mMipmap = other.isMipmap();
        this.mShouldRecycle = other.willRecycle();
        this.mTextureName = other.getTextureName();
        this.mTextureType = other.getTextureType();
        this.mWrapType = other.getWrapType();
        this.mFilterType = other.getFilterType();
        this.mBitmapConfig = other.getBitmapConfig();
        this.mCompressedTexture = other.getCompressedTexture();
        this.mGLTextureType = other.getGLTextureType();
        this.mMaterialsUsingTexture = other.mMaterialsUsingTexture;
    }

    public int getTextureId() {
        return this.mTextureId;
    }

    public void setTextureId(int textureId) {
        this.mTextureId = textureId;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public void setWidth(int width) {
        this.mWidth = width;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public void setHeight(int height) {
        this.mHeight = height;
    }

    public int getBitmapFormat() {
        return this.mBitmapFormat;
    }

    public void setBitmapFormat(int bitmapFormat) {
        this.mBitmapFormat = bitmapFormat;
    }

    public boolean isMipmap() {
        return this.mMipmap;
    }

    public void setMipmap(boolean mipmap) {
        this.mMipmap = mipmap;
    }

    public boolean willRecycle() {
        return this.mShouldRecycle;
    }

    public void shouldRecycle(boolean shouldRecycle) {
        this.mShouldRecycle = shouldRecycle;
    }

    public String getTextureName() {
        return this.mTextureName;
    }

    public void setTextureName(String textureName) {
        this.mTextureName = textureName;
    }

    public TextureType getTextureType() {
        return this.mTextureType;
    }

    public WrapType getWrapType() {
        return this.mWrapType;
    }

    public void setWrapType(WrapType wrapType) {
        this.mWrapType = wrapType;
    }

    public FilterType getFilterType() {
        return this.mFilterType;
    }

    public void setFilterType(FilterType filterType) {
        this.mFilterType = filterType;
    }

    public Bitmap.Config getBitmapConfig() {
        return this.mBitmapConfig;
    }

    public void setBitmapConfig(Bitmap.Config bitmapConfig) {
        this.mBitmapConfig = bitmapConfig;
    }

    public int getGLTextureType() {
        return this.mGLTextureType;
    }

    public void setGLTextureType(int glTextureType) {
        this.mGLTextureType = glTextureType;
    }

    public void setOwnerIdentity(String identity) {
        this.mOwnerIdentity = identity;
    }

    public String getOwnerIdentity() {
        return this.mOwnerIdentity;
    }

    public boolean registerMaterial(Material material) {
        if (this.isMaterialRegistered(material)) {
            return false;
        }
        this.mMaterialsUsingTexture.add(material);
        return true;
    }

    public boolean unregisterMaterial(Material material) {
        return this.mMaterialsUsingTexture.remove(material);
    }

    private boolean isMaterialRegistered(Material material) {
        int count = this.mMaterialsUsingTexture.size();
        for (int i = 0; i < count; ++i) {
            if (this.mMaterialsUsingTexture.get(i) != material) continue;
            return true;
        }
        return false;
    }

    public void setInfluence(float influence) {
        this.mInfluence = influence;
    }

    public float getInfluence() {
        return this.mInfluence;
    }

    public void setRepeatU(float value) {
        this.mRepeat[0] = value;
    }

    public float getRepeatU() {
        return this.mRepeat[0];
    }

    public void setRepeatV(float value) {
        this.mRepeat[1] = value;
    }

    public float getRepeatV() {
        return this.mRepeat[1];
    }

    public void setRepeat(float u, float v) {
        this.mRepeat[0] = u;
        this.mRepeat[1] = v;
    }

    public float[] getRepeat() {
        return this.mRepeat;
    }

    public void enableOffset(boolean value) {
        this.mEnableOffset = value;
    }

    public boolean offsetEnabled() {
        return this.mEnableOffset;
    }

    public void setOffsetU(float value) {
        this.mOffset[0] = value;
    }

    public float getOffsetU() {
        return this.mOffset[0];
    }

    public float[] getOffset() {
        return this.mOffset;
    }

    public void setOffsetV(float value) {
        this.mOffset[1] = value;
    }

    public float getOffsetV() {
        return this.mOffset[1];
    }

    public void setOffset(float u, float v) {
        this.mOffset[0] = u;
        this.mOffset[1] = v;
    }

    public void setCompressedTexture(ACompressedTexture compressedTexture) {
        this.mCompressedTexture = compressedTexture;
    }

    public ACompressedTexture getCompressedTexture() {
        return this.mCompressedTexture;
    }

    abstract void add() throws TextureException;

    abstract void remove() throws TextureException;

    abstract void replace() throws TextureException;

    abstract void reset() throws TextureException;

    public static class TextureException
    extends Exception {
        private static final long serialVersionUID = -4218033240897223177L;

        public TextureException() {
        }

        public TextureException(String msg) {
            super(msg);
        }

        public TextureException(Throwable throwable) {
            super(throwable);
        }

        public TextureException(String msg, Throwable throwable) {
            super(msg, throwable);
        }
    }

    public static enum FilterType {
        NEAREST,
        LINEAR;

    }

    public static enum WrapType {
        CLAMP,
        REPEAT;

    }

    public static enum TextureType {
        DIFFUSE,
        NORMAL,
        SPECULAR,
        ALPHA,
        RENDER_TARGET,
        DEPTH_BUFFER,
        LOOKUP,
        CUBE_MAP,
        SPHERE_MAP,
        VIDEO_TEXTURE,
        COMPRESSED;

    }
}

