/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.materials.textures;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.rajawali3d.materials.textures.ACompressedTexture;
import org.rajawali3d.materials.textures.ATexture;
import org.rajawali3d.materials.textures.TextureManager;

public abstract class ASingleTexture
extends ATexture {
    protected Bitmap mBitmap;
    protected ByteBuffer mByteBuffer;
    protected int mResourceId;

    protected ASingleTexture() {
    }

    public ASingleTexture(ATexture.TextureType textureType, String textureName) {
        super(textureType, textureName);
    }

    public ASingleTexture(ATexture.TextureType textureType, int resourceId) {
        this(textureType, TextureManager.getInstance().getContext().getResources().getResourceName(resourceId));
        this.setResourceId(resourceId);
    }

    public ASingleTexture(ATexture.TextureType textureType, String textureName, Bitmap bitmap) {
        this(textureType, textureName);
        this.setBitmap(bitmap);
    }

    public ASingleTexture(ATexture.TextureType textureType, String textureName, ACompressedTexture compressedTexture) {
        super(textureType, textureName, compressedTexture);
    }

    public ASingleTexture(ASingleTexture other) {
        super(other);
        this.setFrom(other);
    }

    @Override
    public abstract ASingleTexture clone();

    public void setFrom(ASingleTexture other) {
        super.setFrom(other);
        this.setBitmap(other.getBitmap());
        this.setByteBuffer(other.getByteBuffer());
    }

    public void setResourceId(int resourceId) {
        this.mResourceId = resourceId;
        Context context = TextureManager.getInstance().getContext();
        BitmapFactory.Options bitmapScalingOptions = new BitmapFactory.Options();
        bitmapScalingOptions.inScaled = false;
        this.setBitmap(BitmapFactory.decodeResource((Resources)context.getResources(), (int)resourceId, (BitmapFactory.Options)bitmapScalingOptions));
    }

    public int getResourceId() {
        return this.mResourceId;
    }

    public void setBitmap(Bitmap bitmap) {
        this.mBitmap = bitmap;
    }

    public Bitmap getBitmap() {
        return this.mBitmap;
    }

    public void setByteBuffer(ByteBuffer byteBuffer) {
        this.mByteBuffer = byteBuffer;
    }

    public ByteBuffer getByteBuffer() {
        return this.mByteBuffer;
    }

    @Override
    void add() throws ATexture.TextureException {
        if (this.mCompressedTexture != null) {
            this.mCompressedTexture.add();
            this.setWidth(this.mCompressedTexture.getWidth());
            this.setHeight(this.mCompressedTexture.getHeight());
            this.setTextureId(this.mCompressedTexture.getTextureId());
            return;
        }
        if (this.mBitmap == null && (this.mByteBuffer == null || this.mByteBuffer.limit() == 0)) {
            throw new ATexture.TextureException("Texture could not be added because there is no Bitmap or ByteBuffer set.");
        }
        if (this.mBitmap != null) {
            this.setBitmapFormat(this.mBitmap.getConfig() == Bitmap.Config.ARGB_8888 ? 6408 : 6407);
            this.setWidth(this.mBitmap.getWidth());
            this.setHeight(this.mBitmap.getHeight());
        }
        int[] genTextureNames = new int[1];
        GLES20.glGenTextures((int)1, (int[])genTextureNames, (int)0);
        int textureId = genTextureNames[0];
        if (textureId > 0) {
            GLES20.glBindTexture((int)3553, (int)textureId);
            if (this.isMipmap()) {
                if (this.mFilterType == ATexture.FilterType.LINEAR) {
                    GLES20.glTexParameterf((int)3553, (int)10241, (float)9987.0f);
                } else {
                    GLES20.glTexParameterf((int)3553, (int)10241, (float)9984.0f);
                }
            } else if (this.mFilterType == ATexture.FilterType.LINEAR) {
                GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
            } else {
                GLES20.glTexParameterf((int)3553, (int)10241, (float)9728.0f);
            }
            if (this.mFilterType == ATexture.FilterType.LINEAR) {
                GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
            } else {
                GLES20.glTexParameterf((int)3553, (int)10240, (float)9728.0f);
            }
            if (this.mWrapType == ATexture.WrapType.REPEAT) {
                GLES20.glTexParameteri((int)3553, (int)10242, (int)10497);
                GLES20.glTexParameteri((int)3553, (int)10243, (int)10497);
            } else {
                GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
                GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
            }
            if (this.mBitmap == null) {
                if (this.mWidth == 0 || this.mHeight == 0 || this.mBitmapFormat == 0) {
                    throw new ATexture.TextureException("Could not create ByteBuffer texture. One or more of the following properties haven't been set: width, height or bitmap format");
                }
                GLES20.glTexImage2D((int)3553, (int)0, (int)this.mBitmapFormat, (int)this.mWidth, (int)this.mHeight, (int)0, (int)this.mBitmapFormat, (int)5121, (Buffer)this.mByteBuffer);
            } else {
                GLUtils.texImage2D((int)3553, (int)0, (int)this.mBitmapFormat, (Bitmap)this.mBitmap, (int)0);
            }
            if (this.isMipmap()) {
                GLES20.glGenerateMipmap((int)3553);
            }
        } else {
            throw new ATexture.TextureException("Couldn't generate a texture name.");
        }
        this.setTextureId(textureId);
        if (this.mShouldRecycle) {
            if (this.mBitmap != null) {
                this.mBitmap.recycle();
                this.mBitmap = null;
            }
            if (this.mByteBuffer != null) {
                this.mByteBuffer = null;
            }
        }
        GLES20.glBindTexture((int)3553, (int)0);
    }

    @Override
    void remove() throws ATexture.TextureException {
        if (this.mCompressedTexture != null) {
            this.mCompressedTexture.remove();
        } else {
            GLES20.glDeleteTextures((int)1, (int[])new int[]{this.mTextureId}, (int)0);
        }
    }

    @Override
    void replace() throws ATexture.TextureException {
        if (this.mCompressedTexture != null) {
            this.mCompressedTexture.replace();
            this.setWidth(this.mCompressedTexture.getWidth());
            this.setHeight(this.mCompressedTexture.getHeight());
            this.setTextureId(this.mCompressedTexture.getTextureId());
            return;
        }
        if (this.mBitmap == null && (this.mByteBuffer == null || this.mByteBuffer.limit() == 0)) {
            throw new ATexture.TextureException("Texture could not be replaced because there is no Bitmap or ByteBuffer set.");
        }
        GLES20.glBindTexture((int)3553, (int)this.mTextureId);
        if (this.mBitmap != null) {
            int bitmapFormat;
            int n = bitmapFormat = this.mBitmap.getConfig() == Bitmap.Config.ARGB_8888 ? 6408 : 6407;
            if (this.mBitmap.getWidth() != this.mWidth || this.mBitmap.getHeight() != this.mHeight) {
                throw new ATexture.TextureException("Texture could not be updated because the texture size is different from the original.");
            }
            if (bitmapFormat != this.mBitmapFormat) {
                throw new ATexture.TextureException("Texture could not be updated because the bitmap format is different from the original");
            }
            GLUtils.texSubImage2D((int)3553, (int)0, (int)0, (int)0, (Bitmap)this.mBitmap, (int)this.mBitmapFormat, (int)5121);
        } else if (this.mByteBuffer != null) {
            if (this.mWidth == 0 || this.mHeight == 0 || this.mBitmapFormat == 0) {
                throw new ATexture.TextureException("Could not update ByteBuffer texture. One or more of the following properties haven't been set: width, height or bitmap format");
            }
            GLES20.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)this.mWidth, (int)this.mHeight, (int)this.mBitmapFormat, (int)5121, (Buffer)this.mByteBuffer);
        }
        if (this.mMipmap) {
            GLES20.glGenerateMipmap((int)3553);
        }
        GLES20.glBindTexture((int)3553, (int)0);
    }

    @Override
    void reset() throws ATexture.TextureException {
        if (this.mCompressedTexture != null) {
            this.mCompressedTexture.reset();
            return;
        }
        if (this.mBitmap != null) {
            this.mBitmap.recycle();
            this.mBitmap = null;
        }
        if (this.mByteBuffer != null) {
            this.mByteBuffer.clear();
            this.mByteBuffer = null;
        }
    }

    @Override
    public void setWrapType(ATexture.WrapType wrapType) {
        super.setWrapType(wrapType);
        if (this.mCompressedTexture != null) {
            this.mCompressedTexture.setWrapType(wrapType);
        }
    }

    @Override
    public void setFilterType(ATexture.FilterType filterType) {
        super.setFilterType(filterType);
        if (this.mCompressedTexture != null) {
            this.mCompressedTexture.setFilterType(filterType);
        }
    }
}

