/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.materials.textures;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import java.nio.ByteBuffer;
import org.rajawali3d.materials.textures.ACompressedTexture;
import org.rajawali3d.materials.textures.ATexture;
import org.rajawali3d.materials.textures.TextureManager;

public abstract class AMultiTexture
extends ATexture {
    protected Bitmap[] mBitmaps;
    protected ByteBuffer[] mByteBuffers;
    protected ACompressedTexture[] mCompressedTextures;
    protected int[] mResourceIds;

    protected AMultiTexture() {
    }

    public AMultiTexture(ATexture.TextureType textureType, String textureName) {
        super(textureType, textureName);
    }

    public AMultiTexture(ATexture.TextureType textureType, String textureName, int[] resourceIds) {
        super(textureType, textureName);
        this.setResourceIds(resourceIds);
    }

    public AMultiTexture(ATexture.TextureType textureType, String textureName, Bitmap[] bitmaps) {
        super(textureType, textureName);
        this.setBitmaps(bitmaps);
    }

    public AMultiTexture(ATexture.TextureType textureType, String textureName, ByteBuffer[] byteBuffers) {
        super(textureType, textureName);
        this.setByteBuffers(byteBuffers);
    }

    public AMultiTexture(ATexture.TextureType textureType, String textureName, ACompressedTexture[] compressedTextures) {
        super(textureType, textureName);
        this.setCompressedTextures(compressedTextures);
    }

    public AMultiTexture(ATexture other) {
        super(other);
    }

    public void setFrom(AMultiTexture other) {
        super.setFrom(other);
        this.setBitmaps(this.mBitmaps);
        this.setResourceIds(this.mResourceIds);
        this.setByteBuffers(this.mByteBuffers);
    }

    public void setResourceIds(int[] resourceIds) {
        this.mResourceIds = resourceIds;
        int numResources = resourceIds.length;
        this.mBitmaps = new Bitmap[numResources];
        Context context = TextureManager.getInstance().getContext();
        for (int i = 0; i < numResources; ++i) {
            this.mBitmaps[i] = BitmapFactory.decodeResource((Resources)context.getResources(), (int)resourceIds[i]);
        }
    }

    public int[] getResourceIds() {
        return this.mResourceIds;
    }

    public void setBitmaps(Bitmap[] bitmaps) {
        this.mBitmaps = bitmaps;
    }

    public Bitmap[] getBitmaps() {
        return this.mBitmaps;
    }

    public void setByteBuffers(ByteBuffer[] byteBuffers) {
        this.mByteBuffers = byteBuffers;
    }

    public ByteBuffer[] getByteBuffers() {
        return this.mByteBuffers;
    }

    public ACompressedTexture[] getCompressedTextures() {
        return this.mCompressedTextures;
    }

    public void setCompressedTextures(ACompressedTexture[] compressedTextures) {
        this.mCompressedTextures = compressedTextures;
    }

    @Override
    void reset() throws ATexture.TextureException {
        if (this.mBitmaps != null) {
            for (Bitmap bitmap : this.mBitmaps) {
                bitmap.recycle();
                this.mBitmaps[i] = null;
            }
        }
        if (this.mByteBuffers != null) {
            for (ByteBuffer byteBuffer : this.mByteBuffers) {
                byteBuffer.clear();
                this.mByteBuffers[i] = null;
            }
        }
        if (this.mCompressedTextures != null) {
            for (ACompressedTexture texture : this.mCompressedTextures) {
                texture.remove();
                this.mCompressedTextures[i] = null;
            }
        }
    }
}

