/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.materials.textures;

import android.opengl.GLES20;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.rajawali3d.materials.textures.ATexture;

public abstract class ACompressedTexture
extends ATexture {
    protected ByteBuffer[] mByteBuffers;
    protected CompressionType mCompressionType;
    protected int mCompressionFormat;

    protected ACompressedTexture() {
        this.mTextureType = ATexture.TextureType.COMPRESSED;
        this.mWrapType = ATexture.WrapType.REPEAT;
    }

    public ACompressedTexture(ACompressedTexture other) {
        this();
        this.setFrom(other);
    }

    public ACompressedTexture(String textureName) {
        this();
        this.mTextureType = ATexture.TextureType.COMPRESSED;
        this.mTextureName = textureName;
    }

    public ACompressedTexture(String textureName, ByteBuffer byteBuffer) {
        this(textureName);
        this.setByteBuffer(byteBuffer);
    }

    public ACompressedTexture(String textureName, ByteBuffer[] byteBuffers) {
        this(textureName);
        this.setByteBuffers(byteBuffers);
    }

    public void setFrom(ACompressedTexture other) {
        super.setFrom(other);
        this.mCompressionType = other.getCompressionType();
        this.mCompressionFormat = other.getCompressionFormat();
    }

    public CompressionType getCompressionType() {
        return this.mCompressionType;
    }

    public void setCompressionType(CompressionType compressionType) {
        this.mCompressionType = compressionType;
    }

    public int getCompressionFormat() {
        return this.mCompressionFormat;
    }

    public void setCompressionFormat(int compressionFormat) {
        this.mCompressionFormat = compressionFormat;
    }

    public void setByteBuffer(ByteBuffer byteBuffer) {
        this.setByteBuffers(new ByteBuffer[]{byteBuffer});
    }

    public void setByteBuffers(ByteBuffer[] byteBuffers) {
        this.mByteBuffers = byteBuffers;
    }

    public ByteBuffer[] getByteBuffers() {
        return this.mByteBuffers;
    }

    @Override
    void add() throws ATexture.TextureException {
        int[] textures = new int[1];
        GLES20.glGenTextures((int)1, (int[])textures, (int)0);
        int textureId = textures[0];
        if (textureId > 0) {
            GLES20.glBindTexture((int)3553, (int)textureId);
            if (this.mFilterType == ATexture.FilterType.LINEAR) {
                GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
            } else {
                GLES20.glTexParameterf((int)3553, (int)10241, (float)9728.0f);
            }
            if (this.mFilterType == ATexture.FilterType.LINEAR) {
                GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
            } else {
                GLES20.glTexParameterf((int)3553, (int)10240, (float)9728.0f);
            }
            if (this.mWrapType == ATexture.WrapType.REPEAT) {
                GLES20.glTexParameteri((int)3553, (int)10242, (int)10497);
                GLES20.glTexParameteri((int)3553, (int)10243, (int)10497);
            } else {
                GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
                GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
            }
            if (this.mByteBuffers != null && this.mByteBuffers.length == 0 || this.mByteBuffers == null) {
                GLES20.glCompressedTexImage2D((int)3553, (int)0, (int)this.mCompressionFormat, (int)this.mWidth, (int)this.mHeight, (int)0, (int)0, null);
            } else {
                int w = this.mWidth;
                int h = this.mHeight;
                for (int i = 0; i < this.mByteBuffers.length; ++i) {
                    GLES20.glCompressedTexImage2D((int)3553, (int)i, (int)this.mCompressionFormat, (int)w, (int)h, (int)0, (int)this.mByteBuffers[i].capacity(), (Buffer)this.mByteBuffers[i]);
                    w = w > 1 ? w / 2 : 1;
                    h = h > 1 ? h / 2 : 1;
                }
            }
        } else {
            throw new ATexture.TextureException("Couldn't generate a texture name.");
        }
        this.setTextureId(textureId);
        for (int i = 0; i < this.mByteBuffers.length; ++i) {
            if (this.mByteBuffers[i] == null) continue;
            this.mByteBuffers[i].limit(0);
        }
        GLES20.glBindTexture((int)3553, (int)0);
    }

    @Override
    void remove() throws ATexture.TextureException {
        GLES20.glDeleteTextures((int)1, (int[])new int[]{this.mTextureId}, (int)0);
    }

    @Override
    void replace() throws ATexture.TextureException {
        if (this.mByteBuffers == null || this.mByteBuffers.length == 0) {
            throw new ATexture.TextureException("Texture could not be replaced because there is no ByteBuffer set.");
        }
        if (this.mWidth == 0 || this.mHeight == 0) {
            throw new ATexture.TextureException("Could not update ByteBuffer texture. One or more of the following properties haven't been set: width or height");
        }
        GLES20.glBindTexture((int)3553, (int)this.mTextureId);
        int w = this.mWidth;
        int h = this.mHeight;
        for (int i = 0; i < this.mByteBuffers.length; ++i) {
            GLES20.glCompressedTexSubImage2D((int)3553, (int)i, (int)0, (int)0, (int)w, (int)h, (int)this.mCompressionFormat, (int)this.mByteBuffers[i].capacity(), (Buffer)this.mByteBuffers[i]);
            w = w > 1 ? w / 2 : 1;
            h = h > 1 ? h / 2 : 1;
        }
        GLES20.glBindTexture((int)3553, (int)0);
    }

    @Override
    void reset() throws ATexture.TextureException {
        if (this.mByteBuffers != null) {
            for (int i = 0; i < this.mByteBuffers.length; ++i) {
                if (this.mByteBuffers[i] == null) continue;
                this.mByteBuffers[i].limit(0);
            }
        }
    }

    public static enum CompressionType {
        NONE,
        ETC1,
        ETC2,
        PALETTED,
        THREEDC,
        ATC,
        DXT1,
        PVRTC;

    }
}

