/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.materials.shaders.fragments.texture;

import java.util.List;
import org.rajawali3d.materials.Material;
import org.rajawali3d.materials.shaders.AShaderBase;
import org.rajawali3d.materials.shaders.fragments.texture.ATextureFragmentShaderFragment;
import org.rajawali3d.materials.textures.ATexture;

public class SkyTextureFragmentShaderFragment
extends ATextureFragmentShaderFragment {
    public static final String SHADER_ID = "SKY_TEXTURE_FRAGMENT";

    public SkyTextureFragmentShaderFragment(List<ATexture> textures) {
        super(textures);
    }

    @Override
    public String getShaderId() {
        return SHADER_ID;
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void main() {
        super.main();
        AShaderBase.RVec4 color = (AShaderBase.RVec4)this.getGlobal(AShaderBase.DefaultShaderVar.G_COLOR);
        AShaderBase.RVec4 skyColor = (AShaderBase)this.new AShaderBase.RVec4("skyColor");
        AShaderBase.RVec3 texCoord = (AShaderBase.RVec3)this.getGlobal(AShaderBase.DefaultShaderVar.V_CUBE_TEXTURE_COORD);
        int cubeMapCount = 0;
        for (int i = 0; i < this.mTextures.size(); ++i) {
            if (((ATexture)this.mTextures.get(i)).getTextureType() == ATexture.TextureType.CUBE_MAP) {
                skyColor.assign(this.textureCube(this.muCubeTextures[cubeMapCount++], texCoord));
            }
            skyColor.assignMultiply(this.muInfluence[i]);
            color.assignAdd(skyColor);
        }
    }

    @Override
    public void bindTextures(int nextIndex) {
    }

    @Override
    public void unbindTextures() {
    }

    @Override
    public Material.PluginInsertLocation getInsertLocation() {
        return Material.PluginInsertLocation.IGNORE;
    }
}

