/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.materials.shaders.fragments.texture;

import java.util.List;
import org.rajawali3d.materials.Material;
import org.rajawali3d.materials.shaders.AShaderBase;
import org.rajawali3d.materials.shaders.IShaderFragment;
import org.rajawali3d.materials.shaders.fragments.texture.ATextureFragmentShaderFragment;
import org.rajawali3d.materials.textures.ATexture;

public class EnvironmentMapFragmentShaderFragment
extends ATextureFragmentShaderFragment
implements IShaderFragment {
    public static final String SHADER_ID = "ENVIRONMENT_MAP_TEXTURE_FRAGMENT";

    public EnvironmentMapFragmentShaderFragment(List<ATexture> textures) {
        super(textures);
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void main() {
        super.main();
        AShaderBase.RMat4 inverseV = (AShaderBase.RMat4)this.getGlobal(AShaderBase.DefaultShaderVar.U_INVERSE_VIEW_MATRIX);
        AShaderBase.RVec4 color = (AShaderBase.RVec4)this.getGlobal(AShaderBase.DefaultShaderVar.G_COLOR);
        AShaderBase.RVec4 cmColor = (AShaderBase)this.new AShaderBase.RVec4("cmColor");
        AShaderBase.RVec3 eyeDir = (AShaderBase.RVec3)this.getGlobal(AShaderBase.DefaultShaderVar.V_EYE_DIR);
        AShaderBase.RVec3 normal = (AShaderBase.RVec3)this.getGlobal(AShaderBase.DefaultShaderVar.V_NORMAL);
        AShaderBase.RVec3 reflected = (AShaderBase)this.new AShaderBase.RVec3("reflected");
        reflected.assign(this.reflect(eyeDir.xyz(), normal));
        reflected.assign(this.normalize(reflected));
        int cubeMapCount = 0;
        int sphereMapCount = 0;
        for (int i = 0; i < this.mTextures.size(); ++i) {
            if (((ATexture)this.mTextures.get(i)).getTextureType() == ATexture.TextureType.SPHERE_MAP) {
                reflected.z().assignAdd(1.0f);
                AShaderBase.RFloat m = (AShaderBase)this.new AShaderBase.RFloat("m");
                m.assign(this.inversesqrt(this.dot(reflected, reflected)));
                m.assignMultiply(-0.5f);
                cmColor.assign(this.texture2D(this.muTextures[sphereMapCount++], reflected.xy().multiply(m).add(this.castVec2(0.5f))));
            } else if (((ATexture)this.mTextures.get(i)).getTextureType() == ATexture.TextureType.CUBE_MAP) {
                AShaderBase.RVec3 viewNormal = (AShaderBase)this.new AShaderBase.RVec3("viewNormal");
                viewNormal.assign(this.castVec3(this.multiply(inverseV, this.castVec4(normal, 0.0f))));
                viewNormal.assign(this.normalize(viewNormal));
                reflected.assign(this.reflect(eyeDir.xyz(), viewNormal));
                reflected.assign(this.castVec3(this.multiply(inverseV, this.castVec4(reflected, 0.0f))));
                reflected.x().assignMultiply(-1.0f);
                cmColor.assign(this.textureCube(this.muCubeTextures[cubeMapCount++], reflected));
            }
            cmColor.assignMultiply(this.muInfluence[i]);
            color.assignAdd(cmColor);
        }
    }

    @Override
    public String getShaderId() {
        return SHADER_ID;
    }

    @Override
    public void bindTextures(int nextIndex) {
    }

    @Override
    public void unbindTextures() {
    }

    @Override
    public Material.PluginInsertLocation getInsertLocation() {
        return Material.PluginInsertLocation.IGNORE;
    }
}

