/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.materials.shaders.fragments.texture;

import java.util.List;
import org.rajawali3d.materials.Material;
import org.rajawali3d.materials.shaders.AShaderBase;
import org.rajawali3d.materials.shaders.fragments.texture.ATextureFragmentShaderFragment;
import org.rajawali3d.materials.textures.ATexture;

public class DiffuseTextureFragmentShaderFragment
extends ATextureFragmentShaderFragment {
    public static final String SHADER_ID = "DIFFUSE_TEXTURE_FRAGMENT";

    public DiffuseTextureFragmentShaderFragment(List<ATexture> textures) {
        super(textures);
    }

    @Override
    public String getShaderId() {
        return SHADER_ID;
    }

    @Override
    public void main() {
        super.main();
        AShaderBase.RVec4 color = (AShaderBase.RVec4)this.getGlobal(AShaderBase.DefaultShaderVar.G_COLOR);
        AShaderBase.RVec2 textureCoord = (AShaderBase.RVec2)this.getGlobal(AShaderBase.DefaultShaderVar.G_TEXTURE_COORD);
        AShaderBase.RVec4 texColor = (AShaderBase)this.new AShaderBase.RVec4("texColor");
        for (int i = 0; i < this.mTextures.size(); ++i) {
            ATexture texture = (ATexture)this.mTextures.get(i);
            if (texture.offsetEnabled()) {
                textureCoord.assignAdd(this.getGlobal(AShaderBase.DefaultShaderVar.U_OFFSET, i));
            }
            if (texture.getWrapType() == ATexture.WrapType.REPEAT) {
                textureCoord.assignMultiply(this.getGlobal(AShaderBase.DefaultShaderVar.U_REPEAT, i));
            }
            if (texture.getTextureType() == ATexture.TextureType.VIDEO_TEXTURE) {
                texColor.assign(this.texture2D(this.muVideoTextures[i], textureCoord));
            } else {
                texColor.assign(this.texture2D(this.muTextures[i], textureCoord));
            }
            texColor.assignMultiply(this.muInfluence[i]);
            color.assignAdd(texColor);
        }
    }

    @Override
    public void bindTextures(int nextIndex) {
    }

    @Override
    public void unbindTextures() {
    }

    @Override
    public Material.PluginInsertLocation getInsertLocation() {
        return Material.PluginInsertLocation.IGNORE;
    }
}

