/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.materials.shaders.fragments.texture;

import android.opengl.GLES20;
import java.util.List;
import org.rajawali3d.materials.shaders.AShader;
import org.rajawali3d.materials.shaders.AShaderBase;
import org.rajawali3d.materials.shaders.IShaderFragment;
import org.rajawali3d.materials.textures.ATexture;

public abstract class ATextureFragmentShaderFragment
extends AShader
implements IShaderFragment {
    protected List<ATexture> mTextures;
    protected AShaderBase.RSampler2D[] muTextures;
    protected AShaderBase.RSamplerCube[] muCubeTextures;
    protected AShaderBase.RSamplerExternalOES[] muVideoTextures;
    protected AShaderBase.RFloat[] muInfluence;
    protected AShaderBase.RVec2[] muRepeat;
    protected AShaderBase.RVec2[] muOffset;
    protected int[] muTextureHandles;
    protected int[] muInfluenceHandles;
    protected int[] muRepeatHandles;
    protected int[] muOffsetHandles;

    public ATextureFragmentShaderFragment(List<ATexture> textures) {
        super(AShader.ShaderType.FRAGMENT_SHADER_FRAGMENT);
        this.mTextures = textures;
        this.initialize();
    }

    @Override
    public void initialize() {
        ATexture texture;
        int i;
        super.initialize();
        if (this.mTextures == null) {
            return;
        }
        int numTextures = this.mTextures.size();
        int textureCount = 0;
        int cubeTextureCount = 0;
        int videoTextureCount = 0;
        for (i = 0; i < this.mTextures.size(); ++i) {
            texture = this.mTextures.get(i);
            if (texture.getTextureType() == ATexture.TextureType.CUBE_MAP) {
                ++cubeTextureCount;
                continue;
            }
            if (texture.getTextureType() == ATexture.TextureType.VIDEO_TEXTURE) {
                ++videoTextureCount;
                continue;
            }
            ++textureCount;
        }
        if (textureCount > 0) {
            this.muTextures = new AShaderBase.RSampler2D[textureCount];
        }
        if (cubeTextureCount > 0) {
            this.muCubeTextures = new AShaderBase.RSamplerCube[cubeTextureCount];
        }
        if (videoTextureCount > 0) {
            this.muVideoTextures = new AShaderBase.RSamplerExternalOES[videoTextureCount];
        }
        this.muInfluence = new AShaderBase.RFloat[numTextures];
        this.muRepeat = new AShaderBase.RVec2[numTextures];
        this.muOffset = new AShaderBase.RVec2[numTextures];
        this.muTextureHandles = new int[numTextures];
        this.muInfluenceHandles = new int[numTextures];
        this.muRepeatHandles = new int[numTextures];
        this.muOffsetHandles = new int[numTextures];
        textureCount = 0;
        cubeTextureCount = 0;
        videoTextureCount = 0;
        for (i = 0; i < this.mTextures.size(); ++i) {
            texture = this.mTextures.get(i);
            if (texture.getTextureType() == ATexture.TextureType.CUBE_MAP) {
                this.muCubeTextures[textureCount++] = (AShaderBase.RSamplerCube)this.addUniform(texture.getTextureName(), AShaderBase.DataType.SAMPLERCUBE);
            } else if (texture.getTextureType() == ATexture.TextureType.VIDEO_TEXTURE) {
                this.muVideoTextures[videoTextureCount++] = (AShaderBase.RSamplerExternalOES)this.addUniform(texture.getTextureName(), AShaderBase.DataType.SAMPLER_EXTERNAL_EOS);
            } else {
                this.muTextures[textureCount++] = (AShaderBase.RSampler2D)this.addUniform(texture.getTextureName(), AShaderBase.DataType.SAMPLER2D);
            }
            this.muInfluence[i] = (AShaderBase.RFloat)this.addUniform((AShaderBase.IGlobalShaderVar)AShaderBase.DefaultShaderVar.U_INFLUENCE, texture.getTextureName());
            if (texture.getWrapType() == ATexture.WrapType.REPEAT) {
                this.muRepeat[i] = (AShaderBase.RVec2)this.addUniform((AShaderBase.IGlobalShaderVar)AShaderBase.DefaultShaderVar.U_REPEAT, i);
            }
            if (!texture.offsetEnabled()) continue;
            this.muOffset[i] = (AShaderBase.RVec2)this.addUniform((AShaderBase.IGlobalShaderVar)AShaderBase.DefaultShaderVar.U_OFFSET, i);
        }
    }

    @Override
    public void setLocations(int programHandle) {
        if (this.mTextures == null) {
            return;
        }
        for (int i = 0; i < this.mTextures.size(); ++i) {
            ATexture texture = this.mTextures.get(i);
            this.muTextureHandles[i] = this.getUniformLocation(programHandle, texture.getTextureName());
            this.muInfluenceHandles[i] = this.getUniformLocation(programHandle, (AShaderBase.IGlobalShaderVar)AShaderBase.DefaultShaderVar.U_INFLUENCE, texture.getTextureName());
            if (texture.getWrapType() == ATexture.WrapType.REPEAT) {
                this.muRepeatHandles[i] = this.getUniformLocation(programHandle, (AShaderBase.IGlobalShaderVar)AShaderBase.DefaultShaderVar.U_REPEAT, i);
            }
            if (!texture.offsetEnabled()) continue;
            this.muOffsetHandles[i] = this.getUniformLocation(programHandle, (AShaderBase.IGlobalShaderVar)AShaderBase.DefaultShaderVar.U_OFFSET, i);
        }
    }

    @Override
    public void applyParams() {
        super.applyParams();
        if (this.mTextures == null) {
            return;
        }
        for (int i = 0; i < this.mTextures.size(); ++i) {
            ATexture texture = this.mTextures.get(i);
            GLES20.glUniform1f((int)this.muInfluenceHandles[i], (float)texture.getInfluence());
            if (texture.getWrapType() == ATexture.WrapType.REPEAT) {
                GLES20.glUniform2fv((int)this.muRepeatHandles[i], (int)1, (float[])texture.getRepeat(), (int)0);
            }
            if (!texture.offsetEnabled()) continue;
            GLES20.glUniform2fv((int)this.muOffsetHandles[i], (int)1, (float[])texture.getOffset(), (int)0);
        }
    }

    @Override
    public void main() {
    }
}

